---
title: Visited
localeTitle: Посещенные
---
## Посещенные

Селектор CSS: посещенный изменяет стиль ссылки, которую посетил пользователь. Этот селектор используется, чтобы помочь пользователям различать ссылки, которые у них есть и которые не были посещены.

Если используется несколько псевдоселекторов CSS, селектор: посещенный должен появиться после селектора:.

В приведенном ниже примере, после того, как пользователь нажмет на ссылку, цвет текста изменится с черного на зеленый.

```css
 a { 
   color: black; 
 } 
 
 a:visited { 
   color: green; 
 } 
```

Из-за причин неприкосновенности личной жизни селектор: посещенный ограничен модификацией стилей следующих свойств CSS:

*   цвет
*   фоновый цвет
*   border-color (включая пограничный цвет для отдельных сторон)
*   колонного правило цвета
*   план-цвет
*   заполнение и обводка (для изображений SVG)

#### Дополнительная информация:

*   [Веб-документы MDN](https://developer.mozilla.org/en-US/docs/Web/CSS/:visited)
*   [W3 Школы](https://www.w3schools.com/cssref/sel_visited.asp)
*   [Руководство по трюкам CSS для псевдокласс и элементов](https://www.smashingmagazine.com/2016/05/an-ultimate-guide-to-css-pseudo-classes-and-pseudo-elements/#visited)