---
title: Styling Lists
localeTitle: Списки стилей
---
## Списки стилей

### Списки HTML-списков

В HTML есть два основных типа списков: **упорядоченный** и **неупорядоченный** .

В **упорядоченных** списках ( `<ol></ol>` ) порядок элементов списка важен. Элементы могут отображаться по порядку по номеру, римской цифре, альфа-цифре или марку другого типа. Маркер по умолчанию для упорядоченных списков - это число (или `decimal` ):

> ![](https://github.com/kayfo23/imgs-for-fcc-guide/blob/master/ordered-list.png?raw=true "упорядоченный список")

В **неупорядоченных** списках ( `<ul></ul>` ) порядок элементов списка не имеет значения. Элементы отображаются в формате пули. Маркер по умолчанию для неупорядоченных списков - это круглый маркер или `disc` .

> ![](https://github.com/kayfo23/imgs-for-fcc-guide/blob/master/unordered-list.png?raw=true "неупорядоченный список")

Каждый элемент списка в упорядоченном или неупорядоченном списке создается `<li></li>` .

### Стили списка

Существует три общих свойства, характерных для списков стилей: `list-style-type` , `list-style-position` и `list-style-image` . Существует также стенографическое свойство, которое включает в себя все три.

#### `list-style-type`

Маркеры (или маркеры), которые отображаются в упорядоченных и неупорядоченных списках, могут быть разными способами. Свойство CSS для стилизации типа маркера является типом типа `list-style-type` . Значение по умолчанию для типа `list-style-type` для упорядоченного списка является `decimal` , а по умолчанию для неупорядоченного списка - `disc` .

Пример списка заказа:

> ```css
> /* css */ 
>  ol { 
>   list-style-type: upper-roman; 
>  } 
> 
> ```
> 
> ![](https://github.com/kayfo23/imgs-for-fcc-guide/blob/master/list-style-type-upper-roman.png?raw=true "стиль списка верхнего стиля")

Пример неупорядоченного списка:

> ```css
> /* css */ 
>  ul { 
>   list-style-type: square; 
>  } 
> 
> ```
> 
> ![](https://github.com/kayfo23/imgs-for-fcc-guide/blob/master/list-style-type-square.png?raw=true "квадрат в стиле списка")

Нет примера с маркером:

> ```css
> /* css */ 
>  ul { 
>   list-style-type: none; 
>  } 
> 
> ```
> 
> ![](https://github.com/kayfo23/imgs-for-fcc-guide/blob/master/list-style-type-none.png?raw=true "list-style-type none")

Принятые значения для свойства `list-style-type` :

_Неупорядоченный:_

*   диск (по _умолчанию_ )
*   круг
*   квадрат

_Приказал:_

*   decimal (по _умолчанию_ )
*   десятичное ведущий нуля
*   низший романский
*   Верхняя-римской
*   низший греческий
*   ниже латынь
*   Верхняя латынь
*   армянин
*   грузинский
*   низший-альфа
*   Верхняя-альфа

_Другой:_

*   никто

Примечание. Все перечисленные выше значения свойств могут использоваться для стилирования как упорядоченных, так и неупорядоченных списков (например: упорядоченный список с `square` маркерами).

#### `list-style-position`

`list-style-position` определяет, отображается ли маркер списка внутри или вне элемента элемента списка ( `<li></li>` ). Свойство принимает два значения: `outside` (по умолчанию) или `inside` .

Поместите маркер `outside` элемента элемента списка, и все текстовые строки и подстроки каждого элемента списка будут выравниваться по вертикали:

> ```css
> /* css */ 
>  ul { 
>   list-style-position: outside; /* default */ 
>  } 
> 
> ```
> 
> ![](https://github.com/kayfo23/imgs-for-fcc-guide/blob/master/list-style-position-outside.png?raw=true "list-style-position вне")

Поместите маркер `inside` , и первая текстовая строка каждого элемента списка будет отступом, чтобы освободить место для маркера. Любые подстроки одного и того же элемента списка будут выравниваться с маркером, а не с первой текстовой строкой:

> ```css
> /* css */ 
>  ul { 
>   list-style-position: inside; 
>  } 
> 
> ```
> 
> ![](https://github.com/kayfo23/imgs-for-fcc-guide/blob/master/list-style-position-inside.png?raw=true "стиль списка в стиле")

#### `list-style-image`

Свойство `list-style-image` принимает URL-адрес изображения вместо маркера списка. Значение по умолчанию для этого свойства равно `none` .

> ```css
> /* css */ 
>  ul { 
>   list-style-image: url(https://url-to-image); 
>  } 
> 
> ```

#### Сокращенный `list-style`

`list-style` - это сокращенное свойство для трех свойств стиля, перечисленных выше. Принятый порядок значений `list-style` принимает `list-style` `list-style-type` , `list-style-position` и `list-style-image` . Если какое-либо значение опущено, будет использоваться значение по умолчанию для этого свойства.

> Пример:
> 
> ```css
> /* css */ 
>  ul { 
>   list-style: circle inside none; 
>  } 
> 
> ```
> 
> ![](https://github.com/kayfo23/imgs-for-fcc-guide/blob/master/list-style-shorthand.png?raw=true "сокращенный список")

#### Больше стилей для списка

Теги упорядоченного списка также принимают атрибуты, которые управляют потоками, подсчетами или конкретными значениями маркера его элементов списка. К ним относятся атрибуты `start` , `reversed` и `value` . Дополнительную информацию см. В ресурсах MDN, перечисленных ниже.

### Общий стиль

Список содержимого можно стилизовать так же, как и другие элементы `p` или `div` . `color` , `font-family` , `margin` , `padding` или `border` - всего лишь несколько примеров свойств, которые могут быть добавлены к элементам `ul` , `ol` или `li` .

Обратите внимание, что любые стили, добавленные в элемент `ul` или `ol` будут влиять на весь список. Стили, добавленные непосредственно к элементам `li` будут влиять на отдельные элементы списка. В приведенном ниже примере свойства границы и цвета фона различаются между элементами списка и элементов списка:

> ```css
> /* css */ 
>  ul { 
>   list-style-type: circle; 
>   border: 2px solid blue; 
>   background-color: lightblue; 
>  } 
>  li { 
>   margin: 5px; 
>   background-color: lightyellow; 
>  } 
> 
> ```
> 
> ![](https://github.com/kayfo23/imgs-for-fcc-guide/blob/master/list-styles.png?raw=true "стиль в стиле списка")

#### Интервал между списками

Вы можете заметить дополнительное расстояние перед элементами списка, если для типа `list-style-type` установлено значение `none` . Настройка `padding` на `0` (или любой другой интервал предпочтительнее) в элементе списка будет переопределять это заполнение по умолчанию.

> ```css
> /* css */ 
>  ul { 
>   list-style: none; 
>   padding: 0; 
>  } 
>  li { 
>   padding: 5px 10px; 
>   background-color: #EEEEEE; 
>   border: 1px solid #DDDDDD; 
>  } 
> 
> ```
> 
> ![](https://github.com/kayfo23/imgs-for-fcc-guide/blob/master/list-style-padding.png?raw=true "стиль в стиле списка")

* * *

#### Источники:

Ссылки, приведенные ниже, были указаны при компиляции информации, найденной в этой статье. Пожалуйста, посетите их для получения дополнительной информации по этой теме.

#### Дополнительная информация:

[MDN - Списки стилей](https://developer.mozilla.org/en-US/docs/Learn/CSS/Styling_text/Styling_lists)

[W3Schools - Списки CSS](https://www.w3schools.com/css/css_list.asp)

[CSS-трюки - стиль списка](https://css-tricks.com/almanac/properties/l/list-style/)