---
title: Text Align
localeTitle: Выравнивание текста
---
## Выравнивание текста

Это свойство CSS описывает горизонтальное выравнивание встроенного содержимого в его родительском блочном элементе. `text-align` не контролирует выравнивание элементов блока, он влияет только на их встроенное содержимое.

### Ценности:

Свойство `text-align` задается как одно ключевое слово, выбранное из списка значений ниже:

`text-align: left;` выравнивает текст влево

`text-align: right;` выравнивает текст вправо

`text-align: center;` выравнивает текст по центру

`text-align: justify;` делает линии одинаковой ширины

`text-align: justify-all;` делает линии одинаковой ширины, включая последнюю

`text-align: start;` выравнивает последнюю строку в начале строки

`text-align: end;` выравнивает последнюю строку в конце строки

`text-align: match-parent;` рассчитать начальные и конечные значения в направлении родителя и заменить их соответствующим левым или правым значением.

**Значения выравнивания блока (нестандартный синтаксис)** :

`text-align: -moz-center;`

`text-align: -webkit-center;`

**Глобальные ценности** :

`text-align: inherit;` наследует от своего родительского элемента

`text-align: initial;` значение по умолчанию

`text-align: unset;` применяется либо наследование, либо начальное значение, в зависимости от свойств по умолчанию элемента

#### Дополнительная информация:

*   [CSS1 Spec](https://www.w3.org/TR/REC-CSS1/#text-align)
*   [Спецификация CSS2](https://www.w3.org/TR/CSS21/text.html#alignment-prop)
*   [CSS3 Spec](https://www.w3.org/TR/css-text-3/#justification)
*   [Веб-документы MDN](https://developer.mozilla.org/en-US/docs/Web/CSS/text-align)
*   [Трюки CSS](https://css-tricks.com/almanac/properties/t/text-align/)