---
title: Box Model
localeTitle: Модель коробки
---
## Модель коробки

Понимание CSS Box Model имеет решающее значение для правильной компоновки веб-страницы.

Когда браузер отображает (рисует) веб-страницу, каждый элемент, например, фрагмент текста или изображение, нарисован как прямоугольное поле, соответствующее правилам CSS Box Model.

В центре коробки находится сам контент, который занимает определенную высоту и ширину. Этот регион известен как область **содержимого** . Размер области содержимого может быть автоматически определен или вы можете явно задать размер высоты и ширины. (см. примечание ниже относительно `box-sizing` )

![Изображение области содержимого](https://raw.githubusercontent.com/johnkennedy9147/Resources/master/CSS%20Box%20Model%20Images/content%20area.jpg)

Вокруг области содержимого это регион, известный как **зона заполнения** . Размер прокладки может быть одинаковым (с `padding` ), или вы можете установить индивидуально для верхних, правых, нижних и левых paddings (с `padding-top` , `padding-right` , `padding-bottom` и `padding-left` ) ,

![Изображение](https://raw.githubusercontent.com/johnkennedy9147/Resources/master/CSS%20Box%20Model%20Images/padding%20area.jpg)

Далее, есть **Граница** . Это создает границу вокруг элемента и его отступы. Вы можете установить толщину ( `border-width` ), цвет ( `border-color` ) и стиль ( `border-style` ) границы. Параметры стиля не включают `none` (без границы), `solid` , `dashed` , `dotted` и нескольких других. Кроме того, вы можете установить границы по 4 стороны отдельно; например, верхняя граница с `border-top-width` , `border-top-color` и `border-top-style` по толщине, цвету и стилю. (См. Примечание ниже относительно `box-sizing` .)

![Изображение области границы](https://raw.githubusercontent.com/johnkennedy9147/Resources/master/CSS%20Box%20Model%20Images/border%20area.jpg)

Наконец, есть **Область Маржи** . Это создает прозрачное пространство вокруг элемента, заполнения и границы. Снова вы можете индивидуально установить верхние, правые, нижние и левые поля (с `margin-top` , по `margin-right` , по `margin-bottom` и по `margin-left` ). При определенных обстоятельствах возникает крах, и поля между соседними элементами могут совместно использоваться.

![Изображение области поля](https://raw.githubusercontent.com/johnkennedy9147/Resources/master/CSS%20Box%20Model%20Images/margin%20area2.jpg)

**`box-sizing`** По умолчанию для этого свойства используется `content-box` . Если вы используете значение по умолчанию, то модель окна позволит автору указать размер области содержимого. Однако их можно использовать, чтобы вместо этого указать размер пограничной области. Это делается путем изменения свойства `box-sizing` в `border-box` . Иногда это упрощает компоновку. Вы можете установить свойство `box-sizing` ячейки для каждого элемента по своему желанию.

#### Дополнительная информация:

[MDN](https://developer.mozilla.org/en-US/docs/Learn/CSS/Introduction_to_CSS/Box_model)