---
title: CSS Selectors Cheat Sheet
localeTitle: Селекторы CSS
---
# Селекторы CSS

В CSS селекторами являются шаблоны, используемые для выбора элементов DOM.

Вот пример использования селекторов. В следующем коде `a` и `h1` являются селекторами:

```css
a { 
  color: black; 
 } 
 
 h1 { 
  font-size 24px; 
 } 
```

## Чит-лист селекторов

| Селектор | Выбор |  
| --- | --- | | `head` | выбирает элемент с `head` тегом |  
| `.red` | выбирает все элементы с «красным» классом |  
| `#nav` | выбирает элементы с идентификатором «nav» |  
| `div.row` | выбирает все элементы с тегом `div` и классом 'row' | | `[aria-hidden="true"]` | выбирает все элементы с атрибутом `aria-hidden` со значением «true» | | `*` | Селектор подстановочных знаков. Выбирает все элементы DOM. См. Ниже для использования с другими селекторами |

Мы можем комбинировать селекторы интересными способами. Некоторые примеры:

| Селекторы | Выбор |  
| --- | --- | | `li a` | DOM потолочный комбинатор. Все `a` теги, которые ребенок `li` теги |  
| `div.row *` | выбирает все элементы, которые являются потомками (или дочерними) элементов с тегом `div` и классом 'row' |  
| `li > a` | Разностный комбинатор. Выберите прямых потомков, а не всех потомков, таких как селектор потомков |  
| `li + a` | Смежный комбинатор. Он выбирает элемент, которому предшествует предыдущий элемент. В этом случае только первый `a` после каждого `li` . |  
| `li, a` | Выбирает все элементы и все `a` `li` элементы. |  
| `li ~ a` | Комбинированный брат. Выбор `a` элемент следующего в `li` элемента. |

Псевдо-селекторы или псевдоструктурные классы также полезны для выбора структурных элементов из DOM. Вот некоторые из них:

| Селекторы | Выбор | | --- | --- |  
| `:first-child` | Задайте первый элемент сразу внутри (или дочернего элемента) другого элемента |  
| `:last-child` | Задайте последний элемент сразу внутри (или дочернего элемента) другого элемента |  
| `:nth-child()` | Задайте n-й элемент сразу внутри (или дочернего элемента) другого элемента. Принимает целые числа, `even` , `odd` или формулы |  
| `a:not(.name)` | Выбирает все элементы, которые не из `a` `.name` класса |  
| `::after` | Позволяет вставлять содержимое на страницу из CSS вместо HTML. Хотя конечный результат на самом деле отсутствует в DOM, он появляется на странице так, как если бы он был. Этот контент загружается после элементов HTML. |  
| `::before` | Позволяет вставлять содержимое на страницу из CSS вместо HTML. Хотя конечный результат на самом деле отсутствует в DOM, он появляется на странице так, как если бы он был. Это содержимое загружается перед элементами HTML. |

Мы можем использовать псевдоклассы для определения специального состояния элемента DOM, но не будем указывать на элемент самостоятельно. Некоторые примеры:

| Псевдокласс | Выбор | | --- | --- | | `:hover` | выбирает элемент, который наводится указателем мыши |  
| `:focus` | выбирает элемент, получающий фокус с клавиатуры или программы | | `:active` | выбирает элемент, щелкнув указателем мыши |  
| `:link` | выбирает все ссылки, которые еще не были нажаты |  
| `:visited` | выбирает ссылку, которая уже нажата |

## Игры

[CSS Diner](http://flukeout.github.io) - это веб-игра, которая учит почти всему, что нужно знать о объединении селекторов.

## Дополнительная ссылка

Есть еще много селекторов CSS! Узнайте о них в [CodeTuts](http://code.tutsplus.com/tutorials/the-30-css-selectors-you-must-memorize--net-16048) , [CSS-tricks.com](https://css-tricks.com/almanac/selectors/) , [w3schools.com](http://www.w3schools.com/cssref/css_selectors.asp) или в [Mozilla Developer Network](https://developer.mozilla.org/en/docs/Web/Guide/CSS/Getting_started/Selectors) .