---
title: Units
localeTitle: Единицы
---
## Единицы

Многие свойства CSS, такие как `width` , `margin` , `padding` , `font-size` и т. Д., Занимают много места. У CSS есть способ выразить длину в нескольких единицах. Длина представляет собой комбинацию числа и единицы без пробелов. Например, `5px` , `0.9em` и т. Д.

### длина

#### Единицы общей длины

Для выражения длины используется CSS. Более старыми, поддерживаемыми всеми браузерами, являются:

*   **rem** - «r» означает «root»: «root em» -, который равен размеру шрифта, закрепленному на корневом элементе (почти всегда `<html>` ).
*   **vh** и **vw** - Многие гибкие методы веб-дизайна в значительной степени зависят от процентных правил. Тем не менее, процентные меры CSS не всегда являются лучшим решением для всех проблем. Мера **vh** равна 1/100 высоты окна просмотра. Так, например, если высота браузера равна 800px, 1vh равно 8px, и, аналогично, если ширина окна просмотра равна 650px, то 1vw эквивалентно 6.5px.
*   **vmin** и **vmax.** Эти единицы связаны с максимальным или минимальным значением **vh** и **vw** . Например, если браузер был установлен на 1200px в ширину, а высота 600px, 1vmin будет 6px и 1vmax будет 12px. Однако, если ширина была установлена ​​равной 700px, а высота установлена ​​равной 1080px, vmin будет равен 7px и vmax 10.8px.
*   **ex** и **ch** - эти единицы, аналогичные **em** и **rem** , полагаются на текущий шрифт и размер шрифта. Однако, в отличие от **em** и **rem** , эти единицы также полагаются на `font-family` поскольку они определяются на основе мер, специфичных для каждого шрифта. Блок **ch** («единица символа») определяется как ширина нулевого символа («0»). Единица **ex** определяется как «текущая x-высота текущего шрифта или половина 1em». Высота-x данного шрифта - это высота строчного «x» этого шрифта. Это часто средняя отметка шрифта.

| Единица | Описание | | --------------- | ----------------------- | | em | 1 em - вычисленное значение размера шрифта для элемента, на котором он используется. | | ex | 1 ex - текущая высота x шрифта. Обычно x-height (но не всегда, например, если в шрифте нет «x»), равном высоте строчки «x» | | ch | 1 ch - это продвижение глифа «0» (нуль) в текущем шрифте. «ch» означает характер. | | rem | 1 rem - вычисленное значение свойства font-size для корневого элемента документа. | | vw | 1vw составляет 1% от ширины окна просмотра. «vw» означает «ширина окна просмотра». | | vh | 1vh - 1% высоты окна просмотра. «vh» означает «высота видового экрана». | | vmin | равняется меньшему из «vw» или «vh» | | vmax | Равно больше, чем «vw» или «vh» |

Существует два общих типа единиц, используемых для длины и размера в CSS: относительный и абсолютный.

### Относительные единицы

Относительные единицы изменяются относительно текущего размера шрифта или других параметров. Некоторые относительные единицы

*   `em`
*   ширину заглавной буквы M `font-size` текущего элемента.
*   Размер шрифта наследуется от родительских элементов.
*   Пример: `html div { font-size: 16px; } div h3 { font-size: 2rem; }` Здесь `<h3>` будет равняться `32px` так как `font-size` текущего или родительского элемента равен `16px` .
*   `rem`
*   root `em` или ширину прописной буквы M базового `font-size` по умолчанию.
*   Размер шрифта родителя не будет иметь эффекта.
*   Пример: `html body { font-size: 16px; } p { font-size: 1.5rem; }` Здесь `<p>` будет равняться `24px` так как основной `font-size` по умолчанию - `16px` .
*   `%`
*   размер процента относительно размера родителя.
*   Пример: `html div { width: 400px; } div p { width: 75%; }` Поскольку ширина родителя составляет `400px` , ширина внутреннего картографа будет `300px` или 75% от `400px` .
*   `vw`
*   ширину обзора или 1/100 ширины окна просмотра
*   Пример: `html body { width: 100vw; }` `body` заполняет ширину окна просмотра, будь то 417px, 690px или любой ширины.
*   `vh`
*   высоты просмотра или 1/100-й высоты окна просмотра
*   Пример: `html div { height: 50vh; }` Этот `div` будет заполнять половину высоты окна просмотра, будь то 1080px, 1300px или любой высоты.

### Абсолютные единицы

Абсолютные единицы будут одинаковыми независимо от размера экрана или других настроек. Некоторые абсолютные единицы

*   `px`
*   пиксель
*   количество пикселей зависит от качества экрана устройства просмотра
*   `in` , `cm` , `mm`
*   дюйм, сантиметр, мм
*   Дюйм дюйм на маленьком экране или большом экране
*   `pt` , `pc`
*   очки (1/72 дюйма) и пик (12 очков)

пример

```html

p { 
  font-size: 24px; 
 } 
 div { 
  width: 3in; 
  border-width: 3pt; 
 } 
```

Абзац с `font-size: 24px` будет отображаться как 24px на экране телефона, планшета или рабочего стола.

`div` будет отображаться как 3 дюйма в ширину, а `border` на `div` будет иметь толщину 3/72 дюйма, независимо от размера экрана.

### Дополнительная информация:

*   [WebPlatforms Общие сведения о пикселях и других единицах CSS](https://webplatform.github.io/docs/tutorials/understanding-css-units/)
*   [MDN Web Docs - Единицы CSS](https://developer.mozilla.org/en-US/docs/Learn/CSS/Introduction_to_CSS/Values_and_units)
*   [Учебники по веб-дизайну]('https://webdesign.tutsplus.com/articles/7-css-units-you-might-not-know-about--cms-22573)
*   [Справка HTML по CSS-единицам](http://www.htmlhelp.com/reference/css/units.html)