---
title: Web Safe Fonts
localeTitle: Веб-безопасные шрифты
---
## Веб-безопасные шрифты

Веб-безопасные шрифты - это шрифты, которые входят в большинство операционных систем, поэтому такая высокая доступность заключается в том, что дизайнер может ожидать, что типография, включающая веб-безопасные шрифты, будет отображаться точно так же, как и большинство пользователей. Ниже приведены неисчерпывающие списки некоторых шрифтов, которые считаются веб-безопасными на момент написания, классифицированные семейством шрифтов CSS.

Веб-безопасные шрифты с засечками:

*   Грузия
*   Times New Roman

Веб-безопасные шрифты без засечек:

*   Arial
*   Tahoma
*   Trebuchet MS
*   Verdana

Веб-безопасные моноширинные шрифты:

*   Новый Курьер

Стоит отметить, что стеки шрифтов с резервными опциями, включая родовое семейство шрифтов, все равно должны использоваться, даже если ваш дизайн использует только веб-безопасные шрифты. Например:

```css
p { 
  font-family: Tahoma, Arial, sans-serif; 
 } 
```

#### Примечание о веб-шрифтах

Просто потому, что некоторые шрифты более безопасны, чем другие, не означает, что вы должны ограничивать свои проекты использованием только веб-безопасных шрифтов. Современные проекты с CSS также могут использовать веб-шрифты для обеспечения согласованной типографии в разных операционных системах.

#### Дополнительная информация:

*   [Документация MDN: основной стиль текста и шрифта](https://developer.mozilla.org/en-US/docs/Learn/CSS/Styling_text/Fundamentals#Web_safe_fonts)
*   [Документация MDN: веб-шрифты](https://developer.mozilla.org/en-US/docs/Learn/CSS/Styling_text/Web_fonts)
*   [Веб-безопасные шрифты](https://www.cssfontstack.com)