---
title: Will Change
localeTitle: Изменится
---
## Изменится

Свойство will-change позволяет вам сообщить браузеру, какие манипуляции будут происходить с элементом, чтобы его оптимизировать.

```css
.container { 
 will-change: transform; 
 } 
```

Вышеуказанное свойство будет изменено для класса `.container` , в этом случае преобразование элемента может или не может произойти.

Однако, используя это свойство, есть интересный побочный эффект.

Если мы применим к элементу transform: `translateZ (0)` , элемент создаст новый контекст оверлея, а в некоторых браузерах он также добавит слой к собственному потоку рендеринга, что даст нам повышение производительности, которое мы достигаем ,

Следовательно, использование `will-change: transform` , браузер создаст новый оверлейный контекст, независимо от того, применяем ли мы преобразование к элементу или нет.

Главное отметить, что will-change создаст новый оверлейный контекст, только если свойство также создаст новый оверлейный контекст. Поскольку свойство transform создает новый оверлейный контекст, `will-change: transform` также создаст новый оверлейный контекст.

Если вы используете `will-change: display` , то новый контекст оверлея не будет создан, так как никакое значение свойства display не создает новый оверлейный контекст.

Давайте посмотрим на другой пример: `opacity` . Непрозрачность со значением 1 не создает новый оверлейный контекст, но с более низким значением (например, 0,9). Хотя будет изменяться: непрозрачность в любом случае создаст новый оверлейный контекст.

#### Дополнительная информация:

*   [изменится на веб-документы MDN](https://developer.mozilla.org/en-US/docs/Web/CSS/will-change)
*   [CSS изменит модуль уровня 1 (рабочий проект)](https://drafts.csswg.org/css-will-change/#will-change)
*   [Могу ли я использовать: CSS будет изменять свойство](https://caniuse.com/#feat=will-change)