---
title: D3
localeTitle: D3
---
# D3: Документы, управляемые данными

**Документированные документы** (D3.js) - это библиотека JavaScript для создания динамических интерактивных визуализаций данных в веб-браузерах. API **D3.js** содержит различные методы, которые могут быть сгруппированы в следующие логические единицы: _выбор_ , _переходы_ , _массивы_ , _математика_ , _цвет_ , _весы_ , _SVG_ , _время_ , _макеты_ , _география_ , _геометрия_ , _поведение_ .

![Логотип D3.js](https://i2.wp.com/pbiswas101.files.wordpress.com/2018/07/d3.jpg?w=312&h=161)

**D3.js** помогает визуализировать данные, комбинируя мощные методы визуализации и взаимодействия с подходом, основанным на данных, к манипуляции с DOM. Он также предоставляет полные возможности современных браузеров, создавая правильный визуальный интерфейс для ваших данных.

Версия **D3.js** 1.0.0 была выпущена еще 18 февраля 2011 года.

## Почему, D3.js?

_D3_ \* не вводит новое визуальное представление. В отличие от **обработки** , **Raphaël** или **Protovis** , словарный запас графических меток _D3_ поступает непосредственно из веб-стандартов: HTML, SVG и CSS - https://d3js.org/

###### Начать

Есть более 20 000 **+** примеров **D3.js, из которых** вы могли бы научиться, но вы никогда не знаете, насколько доступным будет любой данный! Итак, возникает вопрос: как вы создаете свою визуализацию с первых принципов? Как вы, наверное, видели, API D3 массивный, поэтому позволяет вызывать несколько утилит, которые будут особенно полезны на раннем этапе:

*   **d3 масштаба**

![](https://i0.wp.com/pbiswas101.files.wordpress.com/2018/07/scale.png?w=400&h=100)

*   **d3-форма**

![](https://i0.wp.com/pbiswas101.files.wordpress.com/2018/07/shape.png?w=400&h=100)

*   **d3 выбора**

![](https://i0.wp.com/pbiswas101.files.wordpress.com/2018/07/selection.gif?w=400&h=100)

*   **d3-коллекция**

![](https://i0.wp.com/pbiswas101.files.wordpress.com/2018/07/collection.png?w=400&h=100)

*   **d3-иерархия**

![](https://i2.wp.com/pbiswas101.files.wordpress.com/2018/07/hierarchy.png?w=400&h=100)

*   **d3-зум**

![](https://i1.wp.com/pbiswas101.files.wordpress.com/2018/07/zoom.gif?w=400&h=100)

*   **d3-сила**

![](https://i1.wp.com/pbiswas101.files.wordpress.com/2018/07/force.gif?w=400&h=100)

Таким образом, имея лишь некоторые базовые знания о последних возможностях HTML5, таких как SVG, Canvas, вы можете погрузиться в мир, где библиотека, такая как **D3.js, оживляет** данные! ###### Вклад

*   https://github.com/d3/
    
    ### Ресурсы
    
*   https://en.wikipedia.org/wiki/D3.js
    
*   https://en.wikipedia.org/wiki/Document _Object_ Model
    
*   http://blockbuilder.org/search
    
*   https://d3indepth.com/
    
*   https://davidwalsh.name/learning-d3
    

* * *