---
title: Hadoop
localeTitle: Hadoop
---
## ![Hadoop](http://2s7gjr373w3x22jf92z99mgm5w-wpengine.netdna-ssl.com/wp-content/uploads/2014/08/Hadoop_logo_2.png)

### Вы знали?

Hadoop назван в честь игрушечного слона, принадлежащего сыну Дуга Реттинга. Дуг выбрал название для своего проекта с открытым исходным кодом, так как его легко произносить и находить в результатах поиска. Оригинальный желтый набитый слон, который вдохновил имя, появляется в логотипе Hadoop.

### Что такое Hadoop?

Hadoop - это структура, которая позволяет распределенную обработку больших наборов данных через кластер компьютеров с использованием простых моделей программирования. Он позволяет масштабироваться от отдельных серверов до тысяч компьютеров, каждый из которых предлагает свои собственные локальные вычисления и хранение. Вместо того, чтобы полагаться на аппаратное обеспечение для обеспечения высокой доступности, сам Hadoop предназначен для обнаружения и обработки сбоев на прикладном уровне. Если одна машина в кластере выходит из строя, Hadoop может компенсировать отказ без потери данных. Это позволяет поставлять высокодоступную услугу поверх кластера компьютеров, каждый из которых может быть подвержен ошибкам.

В 2003 году Google опубликовал свою статью в Файловой системе Google (GFS). В нем описана собственная распределенная файловая система, предназначенная для обеспечения эффективного доступа к большим объемам данных с использованием товарного оборудования. Спустя год Google опубликовал еще один документ под названием «MapReduce: упрощенная обработка данных на больших кластерах». В то время Дуг работал в Yahoo. Эти документы были источником вдохновения для его проекта Apache Nutch с открытым исходным кодом. В 2006 году компоненты проекта, известные теперь как Hadoop, вышли из Apache Nutch и были выпущены.

### Почему Hadoop полезен?

По словам IBM: «Каждый день 2,5 миллиарда гигабайт высокоскоростных данных создаются в самых разных формах, таких как сообщения в социальных сетях, информация, собранная в сенсорах и медицинских устройствах, видео и записи транзакций».

Некоторые примеры часто создаваемых данных:

*   Метаданные с телефона
*   Журналы веб-сайта
*   Операции покупки кредитной карты

«Большие данные» относятся к наборам данных, которые слишком велики или сложны для обработки с использованием традиционных программных приложений. Факторы, которые вносят вклад в сложность данных, - это размер набора данных, скорость доступных процессоров и формат данных.

На момент выпуска Hadoop был способен обрабатывать данные в большем масштабе, чем традиционные программы.

### Core Hadoop

Данные хранятся в распределенной файловой системе Hadoop (HDFS). Используя сокращение карты, Hadoop обрабатывает данные в параллельных кусках (обрабатывая несколько частей одновременно), а не в одной очереди. Это сокращает время, необходимое для обработки больших наборов данных.

HDFS работает, сохраняя большие файлы, разделенные на куски, и копируя их на многих серверах. Наличие нескольких копий файлов создает избыточность, которая защищает от потери данных.

### Экосистема Hadoop

Для дополнения Hadoop существует множество других программных пакетов. Эти программы включают экосистему Hadoop. Некоторые программы упрощают загрузку данных в кластер Hadoop, в то время как другие упрощают использование Hadoop.

Экосистема Hadoop включает:

*   Apache Hive
*   Apache Pig
*   Apache HBase
*   Apache Phoenix
*   Apache Spark
*   Apache ZooKeeper
*   Cloudera Impala
*   Потолок Apache
*   Apache Sqoop
*   Apache Oozie

#### Дополнительная информация:

1.  [Курс Udacity на хау](https://www.udacity.com/course/intro-to-hadoop-and-mapreduce--ud617)
2.  [Apache Hadoop](http://hadoop.apache.org/)
3.  [Большие данные Hadoop Tutorial Videos от edureka!](https://www.youtube.com/playlist?list=PL9ooVrP1hQOFrYxqxb0NJCdCABPZNo0pD)
