---
title: Jupyter Notebook
localeTitle: Jupyter Notebook
---
## Jupyter Notebook

Jupyter Notebook - это веб-приложение с открытым исходным кодом. Он позволяет создавать и обмениваться документами, содержащими живой код, уравнения, визуализацию и описательный текст.

Jupyter Notebook помогает создавать и распространять документы, содержащие живой код, уравнения, визуализацию и богатый текст.

Вы можете использовать его для:

*   очистка и трансформация данных
*   Численное моделирование
*   статистическое моделирование
*   визуализация данных
*   машинное обучение

![](https://github.com/indianmoody/images/blob/master/guide_fcc/guides_jupyter_snap.jpeg) Посмотрите свои результаты, когда вы шаг за шагом. Как и на этом изображении.

## Что такое ноутбук Jupyter?

В этом случае «записные книжки» или «документы для ноутбуков» означают документы, содержащие как код, так и богатые текстовые элементы, такие как цифры, ссылки, уравнения. Из-за сочетания кода и текстовых элементов эти документы являются идеальным местом для объединения описания анализа и его результатов, а также могут быть выполнены для выполнения анализа данных в режиме реального времени.

«Jupyter» - это свободная аббревиатура, означающая Julia, Python и R. Эти языки программирования были первыми целевыми языками приложения Jupyter, но в наши дни технология ноутбуков также поддерживает многие другие языки. И вот он у вас есть: Jupyter Notebook.

## Что оно делает?

В качестве сервер-клиентского приложения приложение Jupyter Notebook позволяет редактировать и запускать ваши ноутбуки через веб-браузер. Приложение может быть выполнено на ПК без доступа в Интернет или может быть установлено на удаленном сервере, где вы можете получить к нему доступ через Интернет.

Его двумя основными компонентами являются ядра и приборная панель.

Ядро - это программа, которая запускает и анализирует код пользователя. В приложении Jupyter Notebook есть ядро ​​для кода Python, но есть и ядра, доступные для других языков программирования. Панель управления приложения не только отображает документы ноутбука, которые вы создали, но и может открывать, но также может использоваться для управления ядрами: вы можете запускать и закрывать их, если необходимо.

## Монтаж

Вы можете использовать Anaconda или Pip для установки ноутбука Jupyter. Чтобы сделать это, обратитесь к официальному руководству [Вот.](https://jupyter.readthedocs.io/en/latest/install.html)

#### Дополнительная информация:

\=======

### Особенности

*   Не нужно каждый раз запускать полный код. Просто запустите отдельную ячейку Notebook, чтобы оценить конкретный фрагмент кода.
*   Ноутбук поддерживает более 40 языков программирования, включая Python, R, Julia и Scala.
*   Ноутбуки могут быть доступны другим пользователям, используя электронную почту, Dropbox, GitHub и Jupyter Notebook Viewer.
*   Ваш код может создавать богатый интерактивный вывод: HTML, изображения, видео, LaTeX и пользовательские типы MIME.
*   Используйте инструменты больших данных, такие как Apache Spark, от Python, R и Scala. Исследуйте те же данные с помощью pandas, scikit-learn, ggplot2, TensorFlow.

Ноутбук Jupyter сочетает в себе два компонента:

### Веб-приложение:

Приложение Jupyter Notebook помогает редактировать и запускать документы для документов в веб-браузере, сочетая пояснительный текст, математику, вычисления и мультимедийные материалы.

### Документ для ноутбука:

Приложение Jupyter Notebook может создать «документ Notebook», содержащий как код, так и богатые текстовые элементы. Документ Notebook может быть как читаемым, так и исполняемым.

Эти документы создаются приложением Jupyter Notebook.

## Приложение Jupyter Notebook

В качестве сервер-клиентского приложения приложение Jupyter Notebook позволяет редактировать и запускать ваши ноутбуки через веб-браузер.  
Приложение может быть выполнено на ПК без доступа в Интернет или может быть установлено на удаленном сервере, где вы можете получить к нему доступ через Интернет.

Его двумя основными компонентами являются ядра и приборная панель.

### Ядра

Ядро - это программа, которая запускает и анализирует код пользователя. В приложении Jupyter Notebook есть ядро ​​для кода Python, но есть и ядра, доступные для других языков программирования.

### Приборная доска

Панель управления приложения не только отображает документы ноутбука, которые вы создали, но и может открывать, но также может использоваться для управления ядрами: вы можете запускать и закрывать их, если необходимо.

### Как работают ноутбуки

Ноутбуки Jupyter выросли из проекта IPython, начатого Фернандо Пересом. IPython - это интерактивная оболочка, похожая на обычную оболочку Python, но с замечательными функциями, такими как подсветка синтаксиса и завершение кода. Первоначально ноутбуки работали, отправляя сообщения из веб-приложения (ноутбук, который вы видите в браузере) на ядро ​​IPython (приложение IPython, работающее в фоновом режиме). Ядро выполнило код, а затем отправило его обратно в блокнот. ![Архитектура ноутбуков](https://jupyter.readthedocs.io/en/latest/_images/notebook_components.png)

Когда вы сохраняете ноутбук, он записывается на сервер в виде файла JSON с расширением **.ipynb** Новое название Jupyter происходит от комбинации **Ju** lia, **Py** thon и **R.** для использования Jupyter существует множество ядер для разных языков. вы можете проверить [список доступных ядер Jupyter](https://github.com/jupyter/jupyter/wiki/Jupyter-kernels) .

### Установка ноутбука Jupyter

Ноутбуки Jupyter автоматически поставляются с дистрибутивом. Вы сможете использовать ноутбуки из среды по умолчанию. Для установки ноутбуков Jupyter в среде `conda install jupyter notebook` : `conda install jupyter notebook` Для установки ноутбуков Jupyter с ноутбуком pip: `pip install jupyter notebook`

#### Дополнительная информация:

*   [Веб-сайт Jupyter Org](http://jupyter.org)
*   [Краткое руководство пользователя ноутбука Jupyter / IPython](http://jupyter-notebook-beginner-guide.readthedocs.io/en/latest/what_is_jupyter.html)
*   [Что такое Jupyter Notebook от кодовых дисков, продолжительность 8:24](https://www.youtube.com/watch?v=q_BzsPxwLOE)
*   [Учебник Jupyter для ноутбуков / Учебное пособие по Ipython Notebook, по кодовым основам, продолжительность 24:07](https://www.youtube.com/watch?v=EEEZX_0FMEc)
*   [Дополнительная информация](https://www.datacamp.com/community/tutorials/tutorial-jupyter-notebook)