---
title: Design Patterns
localeTitle: Шаблоны проектирования
---
## Шаблоны проектирования
Шаблон проектирования - это обобщенное решение проблемы разработки программы для некоторой часто повторяющейся задачи. Обычно шаблон - это лишь пример решения, который можно использовать в различных ситуациях, но реализация остается на совести программиста. В объектно-ориентированных языках шаблоны показывают отношения между классами и/или объектами, но не указывают их конкретного содержания.

### Достоинства

* Изучая шаблоны программист развивает свою интуицию.
* Знание шаблонов может сэкономить время при разработке.
* Облегчает коммуникацию между разработчиками, за счет замены описания концепции ссылкой на шаблон.

### Недостатки

* Бездумное применение шаблонов приводит к усложнению программы.
* Шаблон по определению - это повторение, сигнал о недостаточной абстрактности подхода и ограничениях языка программирования.
* Возведение шаблонов в ранг истины в проектной команде ограничивает творческий подход отдельных ее членов.
* Некоторые шаблоны, например MVC, таковыми не являются, что приводит к многочисленным разночтениям, толкованиями и путанице.

### Виды шаблонов проектирования

* **Основные шаблоны (Fundamental)** - как правило реализуются средствами языка программирования.

* **Порождающие шаблоны (Creational)** — абстрагируют процесс создания объектов. Позволяют сделать программу независимой от способа создания, композиции и представления объектов. Шаблон, порождающий классы, использует наследование, чтобы изменять инстанцируемый класс, а шаблон, порождающий объекты, делегирует инстанцирование другому объекту. 

* **Структурные шаблоны (Structural)** - определяют различные сложные структуры, которые изменяют интерфейс уже существующих объектов или его реализацию, позволяя облегчить разработку и оптимизировать программу. 

* **Поведенческие шаблоны (Behavioral)** - определяют взаимодействие между объектами, увеличивая таким образом его гибкость. 

## Полезные ссылки

[Статья на Википедии](https://ru.wikipedia.org/wiki/Шаблон_проектирования)

[Шпаргалка по шаблонам проектирования](https://habr.com/post/210288/)
