---
title: Object Oriented Programming (OOP)
localeTitle: Объектно-ориентированное программирование (ООП)
---
## Контур

*   Почему объект ориентирован (далее сокращенно OO)?
*   Концепции OO
*   Что дальше?

## Почему OO?

В этой парадигме сущности представлены как данные реального мира. Например, мы хотим представить собаку. В парадигме ОО мы просто создаем класс с именем «собака» и даем ему атрибуты (цвет, возраст, пол и т. Д.) И поведение (коры, бега, есть и т. Д.). Поведение изменяется с помощью «методов» (функций простых слов), которые вносят изменения в атрибуты.

## Концепции OO

Что делает программирование OO мощным, это его способность делать следующее:

*   Наследование
*   Полиморфизм
*   Инкапсуляция
*   абстракция

В процедурном программировании мы просто создаем переменные и изменяем их по мере необходимости. Однако при программировании OO мы можем буквально моделировать объекты реального мира. Инкапсуляция достигается путем создания определенного класса для объекта, например собаки. Затем создаются объекты этого класса, которые являются всего лишь экземплярами класса. Каждый объект имеет свои собственные значения атрибутов.

Еще одна чрезвычайно полезная концепция - это наследование. Идея состоит в том, что класс может наследовать атрибуты и поведение из базового класса. Например, при создании игры у нас есть игрок и враг. Мы можем создать базовый класс, называемый человеком, и дать ему атрибуты, такие как имя, возраст, пол и т. Д. Поведение человека может идти и прыгать. Игрок и враг могут наследовать эти «качества» от человека и могут обладать такими качествами, как убить, забить, поесть и т. Д.

Это помогает в повторном использовании кода и делает структуру rcode намного более чистой. Скрытие данных - еще одна интересная функция. В OO мы имеем понятие частных и публичных атрибутов. Доступ к частным атрибутам возможен только с помощью методов этого класса, а общедоступные данные могут быть изменены из любой точки программы (очевидно, в пределах области видимости).

## Что дальше?

Выберите язык OO и создайте базовую игру на основе терминала, чтобы проиллюстрировать эти концепции.