---
title: Photoshop
localeTitle: Photoshop
---
## Photoshop

Adobe Photoshop представляет собой растровое (пиксельное) программное обеспечение, которое используется для создания и редактирования графики / фотографии. Разработчики или дизайнеры обычно используют Photoshop для создания или изменения активов и фотографий для веб-сайтов. Некоторые разработчики также используют фотошоп для дизайна и макетов веб-сайтов, но все чаще используются другие инструменты, такие как Adobe Experience Design и Sketch. Adobe Photoshop доступен для Windows, и Mac (не поддерживается в Linux).

Что же можно сделать в фотошопе? К примеру изменить разрешение изображения (72 точек на дюйм для Интернета) для правильного использования в Интернете и добавление прозрачного фона (с использованием типов файлов .gif и .png). Часто уменьшают размер изображения, которое необходимо будет использовать на веб-сайте. Это уменьшает пространство сервера и снижает время загрузки.


### Резюме

*   Photoshop - растровое программное обеспечение для редактирования изображений.
*   Файл Photoshop - .psd, может экспортировать в большинство типов файлов изображений.

*   Photoshop растровая программа, увеличение картинки впоследствии будет невозможно без потери качества, так что необходимо изначально задать достаточный размер изображения.
*   Загружаемые файлы доступны для Windows и Mac через подписки Adobe.
*   Программа может быть исползована для создания макетов веб-сайтов / пользовательского интерфейса.
*   Имеется множество современных инструментов и функций для редактирования фотографий, которые могут не понадобиться разработчикам.


Photoshop был создан в 1988 году и является наиболее популярным инструментом для решения следующих задач:

*   Фото манипуляции, такие как обрезка изображений, быстрое изменение цветов
*   Разработка [макетов](https://en.wikipedia.org/wiki/Mockup) для веб-сайтов или приложений

*   Проектирование логотипов 1
*   Создание [стилей](http://styletil.es/)
*   Проектирование значков


Photoshop используется веб-дизайнерами, разработчиками мобильных приложений, дизайнерами UX и фотографами, художниками и многими другими.

### Как Photoshop отличается от других инструментов?

Обычно начинающие дизайнеры хотят узнать разницу между Photoshop и Illustrator, чтобы понять, какой инструмент использовать:


Photoshop создает растровые изображения, что означает, что вы можете увидеть пиксели на изображении, если достаточно сильно увеличите изображение.


С другой стороны, Illustrator создает векторную графику. Векторная графика может быть масштабирована без какой либо потери качества.

Например:

![векторный и растровый пример](https://raw.githubusercontent.com/cecyc/textures/master/vector-vs-raster.jpg)

Фотография - растровое изображение, иллюстрация - векторное изображение.

Выберите Photoshop, когда вам нужно работать с комбинацией медиаформатов (фотографий, текста) или когда вам не нужно изменять размер без пикселизации.

### Монтаж

Adobe Photoshop является частью набора программ Creative Cloud. Вы можете установить бесплатную 7-дневную пробную версию Photoshop [через веб-сайт Adobe](https://www.adobe.com/products/photoshop/free-trial-download.html) . После испытания вам нужно будет выбрать ценовой вариант, который будет вам подходить.

Если вам нужно всего лишь Photoshop, вы можете выбрать опцию Single Application, которая составляет 19,99 долл. США в месяц, и включает в себя доступ к TypeKit (хороший источник для шрифтов) и 20 ГБ памяти.

Студенты и преподаватели могут получить [скидку](http://www.adobe-students.com/creativecloud/buy/students.html) на [образование здесь](http://www.adobe-students.com/creativecloud/buy/students.html) .

### основы

#### Начало работы с документом

Когда вы впервые открываете Photoshop, вы, скорее всего, увидите диалоговое окно, которое спросит, хотите ли вы:

*   Открыть существующий документ
*   Создать новый документ

Если вы этого не видите, вы можете перейти в « `File` > « `New...` или использовать сочетание клавиш `CMD` / `ctrl` + `N`

Для веб-проектов вам нужно выбрать меньшее разрешение или dpi (точки на пиксель). Стандарт составляет 72 dpi.

Для проектов печати вы должны выбрать более высокое разрешение. Рекомендуется не менее 300 dpi.

#### обзор

![Окно в Photoshop](https://raw.githubusercontent.com/cecyc/textures/master/photoshop-view.png)

Когда вы открываете Photoshop, вы увидите пару основных компонентов.

Палитра инструментов слева и раздел палитр справа.

В палитре инструментов есть все инструменты, необходимые для управления или редактирования изображения (см. Раздел «Инструменты» ниже).

Некоторые инструменты имеют собственную палитру, которую вы увидите в разделе палитр справа. Вы можете контролировать, какие палитры вы видите, перейдя в `Window` и переключая различные доступные палитры.

Холст - это рабочая область для вашего проекта. Вы можете перемещать элементы вокруг холста и изменять размер холста. Все, что не на холсте, не будет видимым.

#### инструменты

![Палитра инструментов для Photoshop](https://raw.githubusercontent.com/cecyc/textures/master/tools-palette.png)

1.  Переместить инструмент: перемещение элементов вокруг холста.
    
2.  Инструмент «Масштаб»: отметьте и отредактируйте прямоугольный или круговой выбор на слое.
    
3.  Инструмент Lasso: инструмент выбора свободной формы, который вы можете использовать для рисования области выделения.
    
4.  Инструмент волшебной палочки: сделайте выбор из определенного цвета в изображении.
    
5.  Инструмент обрезки: обрезайте размер вашего холста.
    
6.  Инструмент для глазной капельницы: выберите цвет из изображения и загрузите его в свою цветовую палитру.
    
7.  Инструмент для очистки пятнистости: клонировать область с изображения и смешивать ее с другой частью изображения. Используйте его для ретуширования и смешивания.
    
8.  Инструмент «Кисть»: свободный рисунок формы.
    
9.  Clone stamp tool: копировать и вставлять определенные пиксели из изображения. Используйте его для ретуширования.
    
10.  History brush: восстанавливает цвет и другие свойства изображения, основанного на истории. Используйте его для исправления ошибок.
    
11.  Инструмент ластик: стирание свободной формы.
    
12.  Инструмент Paint bucket: заполните выделение цветом (цвет переднего плана по умолчанию).
    
13.  Инструмент «Размытие»: размытие изображения в свободной форме.
    
14.  Инструмент Dodge: осветить часть изображения.
    
15.  Инструмент «Перо»: используйте рисование пути или сделайте выбор с более точной точностью.
    
16.  Инструмент горизонтального типа: введите текст по горизонтальной линии (цвет переднего плана по умолчанию).
    
17.  Инструмент выбора пути: выберите рисованный путь.
    
18.  Инструмент Custom shape: выберите из множества пресетов формы, чтобы нарисовать на холсте.
    
19.  Ручной инструмент: перемещение вокруг холста.
    
20.  Инструмент «Увеличительное стекло»: увеличение или уменьшение холста.
    

В самом низу вы можете установить цвета переднего плана и фона. Вы можете быстро переключать цвета переднего и заднего фона, нажав клавишу `x` .

#### Слои

Палитра слоев доступна с правой стороны окна на палитре.

Проект состоит из нескольких слоев. Каждый элемент проекта - это собственный слой. Слои штабелируются.

В приведенном ниже примере слой «круг» находится поверх слоя «А» на палитре слоев. Это означает, что круг отображается поверх буквы «А» на холсте.

Каждый раз, когда вы хотите предотвратить накладку слоя от случайных настроек, вы можете заблокировать его, выбрав его в окне слоев и нажав кнопку блокировки.

Вы также можете указать заголовок для каждого слоя. Это хорошая практика, особенно когда вы работаете со сложными композициями. Просто дважды щелкните по названию слоя в окне слоев, чтобы переименовать его. Это хороший способ использования папок, которые вы также должны делать для передового опыта в крупных проектах.

![Палитра слоев](https://raw.githubusercontent.com/cecyc/textures/master/layers.png)

#### Импорт шрифтов

Лицензия Creative Creative Cloud поставляется со свободной [учетной](https://typekit.com/) записью [Typekit](https://typekit.com/) . Typekit - это литер, в котором вы можете найти шрифты для использования в цифровых или печатных изданиях.

Чтобы добавить шрифты из Typekit:

1.  Выберите инструмент «Горизонтальный тип» на палитре «Инструменты».
2.  Нажмите на селектор шрифтов в верхнем левом углу.
3.  Нажмите, чтобы `add fonts from Typekit`

![Добавить шрифты от Typekit](https://raw.githubusercontent.com/cecyc/textures/master/add-from-typekit.png)

Это откроет окно браузера и приведет вас к веб-сайту Typekit, где вы можете добавить шрифты в свою учетную запись Photoshop Creative Cloud (убедитесь, что вы вошли в систему с учетными данными вашей учетной записи Adobe). После добавления в вашу учетную запись эти шрифты будут доступны вам при использовании инструмента «Тип».

#### Экспорт файлов

Нажмите « `File` > « `Export` .

Затем вы можете выбрать `Quick export to PNG` , который в большинстве случаев подходит для использования в Интернете.

Если вам нужен другой формат, выберите « `File` > « `Export` > « `Export as...` . Там вы можете выбрать `PNG` , `JPG` или `GIF` .

### Ярлыки для клавиатуры Photoshop

| Горячие клавиши | MAC | WIN | | -------------------------- | ------ | ------ | | Переместить инструмент | V | V |  
| Инструмент Rectangular Marquee | M | M |  
| Инструмент Elliptical Marquee | M | M | | Лассо-инструмент | L | L | | Полигональный инструмент Лассо | L | L | | Магнитный инструмент лассо | L | L | | Инструмент волшебной палочки | W | W | | Инструмент быстрого выбора | W | W | | Уборочный инструмент | C | C | | Инструмент для среза | C | C | | Инструмент выбора среза | C | C | | Инструмент для пипетки | I | I | | Инструмент для цветного пробоотборника | I | I | | Инструмент линейки | I | I | | Инструмент для заметок | I | I | | Инструмент Count | I | I | | Инструмент для чистки зубов Spot Healing | J | J | | Инструмент «Исцеляющая кисть» | J | J | | Патч-инструмент | J | J | | Инструмент «Красный глаз» | J | J | | Инструмент для кисти | B | B | | Инструмент для карандашей | B | B | | Инструмент для замены цвета | B | B | | Инструмент для кисти | B | B | | Клонирование штемпельного инструмента | S | S | | Инструмент штамповочного штампа | S | S |

### Альтернативы Photoshop

*   [Pixelmator](http://www.pixelmator.com/mac/) (только для Mac)
*   [GIMP](https://www.gimp.org/) (Mac и ПК)

### Онлайн-альтернативы Photoshop

*   [Pixlr](https://pixlr.com/)
*   [Photopea](https://www.photopea.com/) (единственный онлайн-инструмент для редактирования файлов .psd)

#### Сноски

1.  Хотя вы можете создавать логотипы в Photoshop, большинство дизайнеров предпочло использовать Illustrator для логотипов, поскольку Illustrator создает векторные изображения, которые упрощают изменение размеров логотипов для нескольких видов использования, таких как небольшие логотипы для визитных карточек или большие логотипы для значков баннера.
2.  Вы можете создать свои собственные кисти в Photoshop, используя опцию Brush Preset. Вы также можете импортировать кисти. Это позволяет не ограничивать себя заданными кистями по умолчанию.
3.  Легче и лучше использовать Photoshop, если вы делаете произведения искусства с использованием графических планшетов, так как у вас есть несколько опций для кистей, чего нет в Illustrator.

#### Дополнительная информация:

*   [Официальный веб-сайт](https://www.adobe.com/products/photoshop.html)
*   [Растровая и векторная графика](https://www.psprint.com/resources/difference-between-raster-vector/)
*   [Обучение и поддержка](https://helpx.adobe.com/support/photoshop.html?promoid=5NHJ8FD2&mv=other)

Альтернативы: Gimp (доступно на Linux и бесплатно)
