---
title: The Programmers Oath
localeTitle: Клятва программистов
---
## Клятва программистов

Клятва программистов - это клятва, созданная Робертом К. Мартином, в которой подчеркивается руководство для лучшей сети. Клятва гласит:

> Чтобы защищать и сохранять честь профессии программистов, Я обещаю, что, насколько мне известно,
> 
> 1.  Я не буду создавать вредоносный код.
> 2.  Код, который я создаю, всегда будет моей лучшей работой. Я не буду сознательно допускать накопление кода, который является дефектным как в поведении, так и в структуре.
> 3.  Я буду производить с каждой версией быстрое, надежное и повторяемое доказательство того, что каждый элемент кода работает так, как должен.
> 4.  Я сделаю частые, небольшие, релизы, чтобы я не мешал прогрессу других.
> 5.  Я буду бесстрашно и неустанно улучшать свои творения при каждой возможности. Я никогда их не деградирую.
> 6.  Я сделаю все возможное, чтобы сохранить производительность самого себя и других, насколько это возможно. Я не буду делать ничего, что снижает эту производительность.
> 7.  Я буду постоянно следить за тем, чтобы другие могли покрыть меня, и что я могу покрыть их.
> 8.  Я буду давать оценки, которые являются честными как по величине, так и по точности. Я не буду давать обещаний без уверенности.
> 9.  Я никогда не перестану учиться и совершенствовать свое ремесло.

[Веб-серия на канале freeCodeCamp](https://www.youtube.com/watch?v=36NgPu9OyRM) разрушает то, что означает клятва, и как следовать присяге.

### Обещание 1

> 1.  Я не буду создавать вредоносный код.

#### Что такое вредоносный код?

Вредный код - это код, который вреден для клиентов, коллег-программистов или для структуры системы. Вред приходит во многих разных формах. **Вы,** как профессиональный программист, обещаете не производить вредоносный код, независимо от того, что это значит, на ваш взгляд, и в суждении ваших сверстников.

### Обещание 2

> 2.  Код, который я создаю, всегда будет моей лучшей работой. Я не буду сознательно допускать накопление кода, который является дефектным как в поведении, так и в структуре.

Как программист, вы хотите верить в свою лучшую работу, и вы никогда не захотите быть в ситуации, когда код, который вы выпускаете, сознательно не является вашей лучшей работой.

Вы не хотите разрешать код, который является дефектным для накопления в вашей системе. Возможно, вы не сможете предотвратить его попадание в вашу систему (например, чрезвычайную ситуацию с выпуском), но вы не позволите ей скопиться.

Обратите внимание, что в обещании есть аспект «поведения» и «структуры» в клятве. Что-то, что является дефектным в поведении, **явно является проблемой,** но код, дефектный по структуре, приведет к снижению производительности ваших членов команды, пока вы не сможете ничего сделать.

### Обещание 3

> 3.  Я буду производить с каждой версией быстрое, надежное и повторяемое доказательство того, что каждый элемент кода работает так, как должен.

Клиенты, пользователи и даже покупатели ожидают, что мы сможем понять, что наш код работает так, как предполагается. Обратите внимание: в клятве есть слова, такие как быстро, уверенно и повторяемо. Вы хотите, чтобы с одной стороны могли доказать, что код все еще работает так, как предполагается.

Если вы добавите новую функцию, которая не сломает ничего более старого, или исправьте новую структуру, которая не сломает ничего, что было там, вы хотите быстро и легко показать, что код все еще делает то, что это намеревается сделать.

### Обещание 4

> 4.  Я сделаю частые, небольшие, релизы, чтобы я не мешал прогрессу других.

Простой способ сказать это - не проверить что-то, и проверить что-то в течение **месяца** . Более проницательный способ сказать это, сказать, что все, что вы делаете в коде, нужно делать небольшими шагами. Если ваши действия в настоящее время блокируют кого-то другого, он не может блокировать их очень долго, **потому что** вы делаете это небольшими шагами.

Преимущество в небольших шагах огромно. Удостоверьтесь, что, когда вы делаете что-то в совершении, вы совершаете почасовые действия. Когда вы делаете регистрацию, часто делайте чек-листы. Когда вы делаете слияния, вы часто сливаетесь.

### Обещание 5

> 5.  Я буду бесстрашно и неустанно улучшать свои творения при каждой возможности. Я никогда их не деградирую.

Каждый раз, когда вы видите проблему в своем коде, тестах или структуре выпуска, **улучшайте их** . Даже если вы не видите проблемы, посмотрите на свой код и скажите себе: «Держу пари, что я могу сделать это лучше, я могу улучшить это в некотором роде».

Мы люди, мы делаем вещи лучше. Это то, что делают люди, или, по крайней мере, то, что мы хотим от людей. Мы будем постоянно совершенствовать наш код и никогда не унижать его намеренно. Никогда не делайте это хуже.

### Обещание 6

> 6.  Я сделаю все возможное, чтобы сохранить производительность самого себя и других, насколько это возможно. Я не буду делать ничего, что снижает эту производительность.

Это все о том, как думать о своих товарищах по команде и окружающих. Люди, которые работают с вами, и люди, которые полагаются на ваш код. Например, не делайте ничего, что замедляет кого-либо еще. Не записывайте функцию со слишком большим количеством аргументов или делайте беспорядок в чужом коде. Не делайте этого, чтобы закодировать то, от чего зависят другие люди, потому что он просто **замедляет их** .

Не ставьте длинные тесты в тестовый комплект. Храните эти тесты быстро. Подумайте о своих товарищах по команде во все времена. Учитывайте природу во все времена. Держите все быстро. Не мешайте их продуктивности.

### Обещание 7

> 7.  Я буду постоянно следить за тем, чтобы другие могли покрыть меня, и что я могу покрыть их.

Это то, что мы часто пренебрегаем делать. Мы - команда, и так, как ведут себя команды, это то, что если другой товарищ по команде опустится, другой товарищ по команде покроет их.

В программном обеспечении это означает, что вам нужно знать, как работают сотрудники ваших товарищей по команде, и где их скрипты, где находятся их файлы, как их код структурирован и т. Д.

Если они пойдут вниз, мы не хотим иметь силосы знаний о наших командах, мы хотим, чтобы эти знания распространялись.

Один из способов сделать это - через парное программирование. Убедитесь, что вы можете прикрывать друг друга.

### Обещание 8

> 8.  Я буду давать оценки, которые являются честными как по величине, так и по точности. Я не буду давать обещаний без уверенности.

Одна из самых больших проблем программистов заключается в том, что они делают оценки, которые считаются обещаниями. Когда вы делаете оценку, вам нужно четко указать, что это предположение, а не очень хорошее предположение. Я бы удостоверился, что когда вы делаете оценки, вы делаете их в трех числах: лучший случай, худший случай и номинальный случай. Убедитесь, что все знают, что может произойти худший случай.

Не делайте обещаний, что вы не уверены, что можете закончить. Если вы пообещаете, вы должны сохранить его.

Когда кто-то говорит вам: «Мне нужно это сделать во вторник», и вы не уверены, можете ли вы это сделать во вторник, тогда вы не обещаете. Вы говорите « **нет** , я не уверен, что смогу это сделать во вторник». Берегитесь очень осторожно, потому что кто-то может сказать, что вы **попытаетесь** , и ваш ответ на это будет: «Я уже пытаюсь». Вы уже пытаетесь изо всех сил, поэтому никогда не позволяйте никому убеждать вас приложить все усилия.

### Обещание 9

> 9.  Я никогда не перестану учиться и совершенствовать свое ремесло.

Это не требует большого объяснения. Вы всегда должны стараться изучать новые языки, новые рамки, новые методы, новые дисциплины, новые процессы. Вам нужно применить то, что вы узнаете, чтобы постоянно навязывать свое ремесло.

### Обещание 10

> 10.  Я буду производить только код, который соответствует этике.

Программисты должны работать над созданием компьютерных систем, которые могут снизить негативные последствия для общества, такие как угрозы безопасности и здоровью, и которые могут облегчить повседневную деятельность и работу. Это «обязательство развиваться по высоким стандартам».

### **В заключение:**

Возможно, должно быть больше обещаний, которые мы должны сделать, по сути, многие из этих обещаний **могут быть даже не практичными** . Однако все эти обещания кажутся важными как-то и разумными, как клятвой, которую возьмет профессиональный программист.