---
title: Chef
localeTitle: лидер
---
## шеф-повар

Шеф-повар - это инструмент автоматизации, который преобразует инфраструктуру в код. Другими словами, это инструмент, который используется для автоматизации создания и настройки вашей инфраструктуры. Он также используется для поддержки вашей инфраструктуры после ее создания.

### Зачем использовать Повара

Перед тем, как полностью завершенное и испытанное приложение поступит в производство, нужно рассмотреть несколько вещей. Некоторые из основных вещей,

*   Создание инфраструктуры (облачный или по-предвыборный)
*   конфигурация
*   Поддержка инфраструктуры

Вы можете вручную создать свою инфраструктуру, настроить ее и сохранить ее. Это очень утомительный процесс, и вероятность совершения ошибки высока. В любом руководстве требуется много внимания к деталям, обучение других в вашей команде и постоянное наблюдение за ним, чтобы убедиться, что все работает должным образом. Если ваше приложение развивается быстро, то каждый раз, когда он идет на производство, вы должны делать все это вручную.

Шеф-повар - это инструмент, помогающий автоматизировать этот процесс. Вы пишете код (шеф-повар использует _Ruby_ ) для вашей инфраструктуры, а источник контролирует его. Шеф-повар будет читать этот код, чтобы автоматически создавать и настраивать вашу инфраструктуру. Преимущества использования шеф-повара,

*   Автоматизация создания и настройки инфраструктуры
*   Автоматизация и обслуживание
*   Вероятность ошибки незначительна
*   Инфраструктура контролируется источником
*   Быстрое развертывание приложения

### Большая картинка и компоненты

![Chef big picture](https://docs.chef.io/_images/chef_overview.svg "Обзор Chef")

Основными компонентами являются,

*   Поваренная книга и рецепты
*   Узел
*   рабочая станция
*   Шеф-повар
*   Поварский клиент

#### Поваренная книга и рецепты

Поваренная книга является основной единицей конфигурации. Он определяет сценарий и содержит все, что требуется для поддержки этого сценария. Cookbook содержит следующие вещи:

*   Рецепты
*   Значения атрибутов
*   Распространение файлов
*   Шаблоны
*   Расширения пользовательских ресурсов и библиотек

Рецепт - самый фундаментальный элемент конфигурации. Он создан с использованием _Ruby_ и состоит из набора ресурсов, необходимых для настройки системы. Он должен храниться в Поваренной книге.

#### Узел

Узел - это любая машина, которой управляет шеф-повар. Это может быть физическое, виртуальное, облачное, сетевое устройство и т. Д.

#### рабочая станция

Рабочая станция (синяя область в большом изображении) - компьютер, на котором работает Chef Development Kit (ChefDK), для разработки и тестирования кулинарных книг и рецептов. В основном, это ваша локальная машина, на которой вы пишете и тестируете сценарии шеф-повара, которые используются позже для автоматизации инфраструктуры. Сценарии шеф-повара с рабочей станции загружаются на сервер Chef после его готовности.

#### Шеф-повар

Шеф-сервер работает как концентратор данных конфигурации. Он хранит все данные конфигурации, такие как кулинарные книги, рецепты, шаблоны и дистрибутивы файлов, которые необходимы для создания и настройки инфраструктуры.

#### Поварский клиент

Клиент-шеф-повар - это агент, который выполняется локально на каждом узле, которым управляет шеф-повар. Он связывается с сервером Chef, чтобы получить данные конфигурации, необходимые для настройки узла. Клиент Chef отвечает за выполнение всех необходимых шагов, чтобы привести узел в ожидаемое состояние. Различные этапы включают,

*   Регистрация и аутентификация узла с помощью сервера Chef
*   Синхронизация поваренных книг
*   Компиляция и запуск необходимых рецептов
*   Обработка исключений и уведомлений

#### Дополнительная информация:

Более подробную документацию можно найти здесь - [Документация шеф-повара](https://docs.chef.io/chef_overview.html "шеф-повар")