---
title: Docker
localeTitle: докер
---
Docker - это программное обеспечение с открытым исходным кодом, предназначенное для облегчения развертывания приложений. Он предлагает возможность создания контейнеров, включая операционную систему, библиотеки и все, что вам нужно для запуска вашего приложения. Поэтому ваше приложение может быть развернуто на любой машине. Его легкая конструкция позволяет вам запустите несколько контейнеров на одной машине. Изображение контейнера представляет собой легкий, автономный исполняемый пакет части программного обеспечения, который включает в себя все необходимо было запустить его.

### Особенности

Контейнеры докеров, работающие на одной машине, разделяют это ядро ​​операционной системы компьютера; они запускаются мгновенно и используют меньше вычислений и ОЗУ. Изображения построенных из уровней файловой системы и обменивающихся общими файлами. Это минимизирует использование диска, а загрузка изображений происходит намного быстрее.

Контейнеры Docker основаны на открытых стандартах и ​​работают на всех основных дистрибутивах \* nix, Microsoft Windows и на любой инфраструктуре, включая виртуальные машины, bare-metal и в облаке.

Контейнеры-докеры изолируют приложения друг от друга и от базовой инфраструктуры. Docker обеспечивает максимальную изоляцию по умолчанию для ограничения приложения вопросы к одному контейнеру, а не всей машине.

## обзор

Изображение контейнера представляет собой легкий, автономный исполняемый пакет части программного обеспечения, который включает все необходимое для его запуска: код, время выполнения, системные инструменты, системные библиотеки, настройки. Доступно как для приложений на базе Linux, так и для Windows, контейнерное программное обеспечение всегда будет работать одинаково независимо от среды. Контейнеры изолируют программное обеспечение от его окружения, например, различия между средами разработки и промежуточной среды и помогают уменьшить конфликты между командами, использующими различное программное обеспечение в одной и той же инфраструктуре.

### Смотрите также

*   Docker Compose: создавать и управлять несколькими контейнерами одновременно.

### Контейнеры Vs. Виртуальные машины

*   Контейнеры виртуализируют операционную систему, делая их более переносимыми, тогда как виртуальные машины виртуализируют оборудование.
*   Контейнеры представляют собой абстракцию на уровне приложения, который вместе связывает код и зависимости. VM - это абстракция физического оборудования, превращающего один сервер во многие. Гипервизор помогает VM сделать это.
*   [КОНТЕЙНЕРЫ НЕ ВМС](https://blog.docker.com/2016/03/containers-are-not-vms/)

### Установка докеров

Докер доступен в двух редакциях: Community Edition (CE) и Enterprise Edition (EE).

[Установите его здесь](https://docs.docker.com/engine/installation/)

После установки попробуйте это
```
$ docker run hello-world 
 
 Hello from Docker! 
```

Это сообщение показывает, что ваша установка работает правильно.

### Где использовать докер

*   [8 проверенных способов использования докеров](https://www.airpair.com/docker/posts/8-proven-real-world-ways-to-use-docker)
    
*   [Что такое докер и когда его использовать?](https://www.ctl.io/developers/blog/post/what-is-docker-and-when-to-use-it/)
    

### Учебники Docker

*   [Документация](https://docs.docker.com/get-started/)
    
*   [Докер для начинающих](https://docker-curriculum.com/)
    
*   [Учебники и курсы докеров](https://hackr.io/tutorials/learn-docker)
    
*   [Обучение докеров. Изучите Докер из Докера. Официальное обучение докеров.](https://training.docker.com/)
    

#### Дополнительная информация:

Вы можете найти много информации на следующих сайтах:

*   [Докер-сайт](https://www.docker.com/)
*   [Докеры](https://docs.docker.com/)
*   [DockerHub](https://hub.docker.com/)