---
title: Gulp
localeTitle: Глоток
---
## Глоток

`Gulp` - это бегун для задач JavaScript, который используется для автоматизации различных задач, которые являются частью рабочего процесса разработки JavaScript. Он используется для запуска заданий, которые вы запрограммировали, и его основным вариантом использования является выполнение повторяющихся действий, которые используются как путь процесса сборки для проекта JavaScript.

### Почему Gulp полезен

Эти задачи часто включают такие вещи, как `code minification` (удаление пробелов из html-файлов и сокращение имен переменных, чтобы уменьшить размер файла) и `css bundling` (преобразование нескольких файлов CSS в один для распространения с вашим приложением), которые необходимы для оптимизации кода для загрузки быстро в веб-браузере.

Причина, по которой `Gulp` полезна в приведенных выше ситуациях, заключается в том, что процесс минимизации и связывания должен происходить с каждым изменением. Было бы неэффективно делать это вручную при каждом изменении, где инструмент `Gulp` , который делает это автоматически, является отличным инструментом для разработчиков JavaScript.

Как и относительно простые примеры выше, `Gulp` имеет сотни плагинов, которые позволяют автоматизировать более сложные задачи. Эти задачи могут включать в себя такие вещи, как:

*   Выполнение модульных тестов для проверки кода работает правильно.
*   Обновление вашего веб-браузера при каждом сохранении файла, позволяющем мгновенно просматривать ваши изменения.
*   Преобразование `SASS` / `LESS` в `CSS` , чтобы его можно было использовать в браузере.
*   Оптимизация изображений для создания `web friendly` версий с меньшими размерами файлов для скорости.

### Как пользоваться Gulp

Чтобы начать использовать `Gulp` , первый шаг - установить его с помощью `npm` . После его установки необходимо создать `gulpfile.js` . Этот `gulpfile` - это файл, содержащий все задачи `Gulp` которые должны выполняться как часть вашего автоматизированного процесса. Задачи написаны на JavaScript. Ниже приведен очень простой пример `gulpfile` , который берет любые файлы `CSS` из папки `client/templates` , их минимизирует и помещает мини-файл в папку `build/css` .

```javascript
var gulp = require('gulp'); 
 var minifyCSS = require('gulp-csso'); 
 
 gulp.task('css', function(){ 
  return gulp.src('client/templates/*.css') 
    .pipe(minifyCSS()) 
    .pipe(gulp.dest('build/css')) 
 }); 
```

Чтобы запустить эту задачу gulp, все, что вам нужно сделать, это ввести `gulp css` в терминал в корне вашего проекта.

Чтобы просмотреть файлы CSS для любых изменений и запустить задачу «css» после ее сохранения.

```javascript
gulp.watch('css') 
  .on('change', ['css']); 
```

### Зависимости задач

По умолчанию gulp будет запускать все задачи, определенные одновременно, и ждать ничего. Чтобы запустить несколько задач в правильном порядке, вы можете добавить задачу в зависимости от другой задачи.

```javascript
gulp.task('two', ['one'], function() { 
    // task 'one' is done now 
 }); 
```

В приведенном выше фрагменте кода задача `two` будет выполняться только после завершения `one` задачи.

Gulpfiles может иметь несколько задач для каждого файла, а задачи также можно разделить на несколько файлов для организации. Это, наряду с доступными 100-ю плагинами, делает его очень гибкой и полезной основой для разработчиков JavaScript.

#### Дополнительная информация:

[Веб-сайт Gulp](https://gulpjs.com/)

[Репозиторий Gulp github](https://github.com/gulpjs/gulp)

[Руководство для начинающих Gulp](https://css-tricks.com/gulp-for-beginners/)