---
title: npm
localeTitle: над уровнем моря
---
## НПМ

npm - это менеджер пакетов и используется для установки и управления зависимостями.

npm занимает центральное место в динамичном сообществе JavaScript (и, в частности, Node.js), делая очень простой процесс повторного использования модулей и кода. В настоящее время npm имеет более 500 000 доступных пакетов.

npm полезен не только для серверных проектов. Также доступны самые популярные интерфейсные библиотеки, такие как Bootstrap и Font Awesome.

**Заметка:**

*   npm выходит из коробки с Node.js, поэтому необходимо сначала установить Node.js
*   npm не имеет полной формы из-за ее использования за пределами Node.js конкретных проектов. Ранее это называлось Node Package Manager.

### npm Использование

npm обычно используется из командной строки. Команды, приведенные ниже, возможно, являются наиболее важными для начала работы:
```
npm init 
```

Выполнение этой команды в корневом каталоге вашего проекта инициализирует ее для использования с npm путем создания файла `package.json` . Вам будет предложено ввести название проекта, описание, имя автора и т. д. Затем эта информация используется для заполнения файла `package.json` , который также будет содержать информацию о зависимостях и требованиях проекта. Вы можете изменить эту информацию вручную позже.
```
npm install [name-of-package] 
```

Это автоматически устанавливает пакет и все его зависимости и сохраняет его в файле `package.json` . Если вы устанавливаете зависимость развития, вы можете использовать `--save-dev` или `-D` . npm затем сохранит пакет как зависимость от разработки.

Пакеты устанавливаются локально в каталоге `node_modules` в `node_modules` каталоге вашего проекта. Иногда вам может потребоваться доступ к пакету через разные проекты. Это делается с помощью `--global` или `-g` . Это часто полезно для инструментов разработки и утилит командной строки.
```
npm install 
```

Запуск npm install в корневом каталоге проекта без определенного имени пакета, устанавливает все зависимости, необходимые для этого проекта. Это рассчитанный в соответствии с файлом `package.json` проекта. Это демонстрирует силу npm, когда одна команда может извлекать десятки или сотни зависимостей автоматически для вас, и полезно, например, когда вы `git clone` репозиторий.

#### Дополнительная информация:

*   Сайт Node.js: [nodejs](https://nodejs.org)
*   На официальном сайте npm вы можете прочитать о npm, а также найти различные доступные пакеты: [npmjs](https://www.npmjs.com)
*   Узнайте больше о npm: [Wikipedia](https://en.wikipedia.org/wiki/Npm_(software))
*   Руководство для новичков для npm: [sitepoint](https://www.sitepoint.com/beginners-guide-node-package-manager/)
*   Если вы хотите получить полную серию видеороликов, проверьте это: [youtube](https://youtu.be/6fj0cpmMiVg)
*   И вот официальная серия от npm: [youtube](https://youtu.be/pa4dc480Apo)