---
title: Puppet
localeTitle: Марионетка
---
## Кукольный

Puppet - это инструмент управления конфигурацией, который позволяет вам автоматизировать настройку и управление вашей инфраструктурой. Это поможет вам сэкономить время, автоматизируя повторяющиеся задачи и обеспечив сохранность ваших систем в нужном состоянии.

Кукольник выпускается в двух вариантах: Puppet Enterprise и кукольный с открытым исходным кодом. Поддерживаемые платформы включают большинство дистрибутивов Linux, различные платформы UNIX и Windows.

Марионеток был разработан [Puppet Labs](https://puppet.com/company) .

### Начиная

Вы можете настроить свою инфраструктуру либо в архитектуре клиент / сервер, либо в автономной архитектуре. Первый использует `agent` Puppet и приложения Puppet `master` , в то время как последний использует приложение Puppet `apply` .

#### Агент / Мастер Архитектура

В этой архитектуре один или несколько узлов запускают основное приложение Puppet. Мастер-серверы управляют информацией о конфигурации всей инфраструктуры.

Управляемые узлы запускают приложение «Кукольный агент» в качестве фоновой службы и периодически запрашивают их `catalog` конфигурации у мастеров-марионеток.

Мастер Puppet компилирует и возвращает каждый каталог узлов, используя несколько источников информации. Эта собранная информация известна как `facts` .

Когда агент Puppet получает каталог, он проверяет каждый ресурс, описанный в нем. Если ресурс не находится в нужном состоянии, агент исправляет его.

#### Автономная архитектура

В этой архитектуре каждый управляемый узел имеет копию полной конфигурации.

Каждый агент Puppet запускает прикладное приложение как запланированное задание или задание cron.

Как и в архитектуре agent / master, приложение Puppet компилирует каталог и проверяет каждый описанный ресурс. Если ресурс не находится в желаемом состоянии, приложение Puppet исправит его.

Как и основное приложение Puppet, приложение Puppet требует доступа к нескольким источникам данных конфигурации, которые он использует для составления каталога для узла, которым он управляет.

#### Каталог

Каталог - это документ, определяющий конфигурацию машины. В нем перечислены все ресурсы, которым необходимо управлять, их желаемое состояние и любые зависимости между ними.

Puppet настраивает систему, сначала компилируя catlog, а затем применяя ее.

#### факты

Кукольный собирает факты обо всех узлах с помощью инструмента под названием `facter` . Facter собирает информацию, необходимую для настройки системы. Например, имена хостов, IP-адреса, имена ОС и другие. Однако также можно добавить дополнительные факты.

Для получения дополнительной информации см. Документацию для архитектуры Puppet.

#### Дополнительная информация:

*   Кукольный официальный [сайт](https://puppet.com)
*   Обзор [архитектуры](https://puppet.com/docs/puppet/5.3/architecture.html) кукол
*   Как использовать кукол для управления серверами. Серия учебников от [DigitalOcean](https://www.digitalocean.com/community/tutorial_series/how-to-use-puppet-to-manage-your-servers-2)