---
title: Vagrant
localeTitle: бродяга
---
## бродяга

Vagrant - это инструмент для создания и управления средами виртуальной машины (VM). Виртуальные машины могут использоваться по любой причине, но особенно полезны для разработчиков и DevOps.

### Почему бродяга полезен

Как разработчик, используя виртуальную машину, вы можете иметь локальную среду для тестирования кода, то же самое, что и производственная среда, независимо от среды, которую вы используете для кодирования.

Для DevOps виртуальные машины очень полезны для создания высоко настраиваемой одноразовой машины для тестирования инфраструктуры, конфигураций, сценариев или чего-либо еще.

С помощью Vagrant для использования виртуальной машины вам нужен только один файл, называемый `VagrantFile` , который содержит виртуальную `VagrantFile` , а также всю необходимую конфигурацию. Таким образом, вы можете легко создать определенную изолированную среду разработки, которая очень портативна и может использоваться и использоваться всеми членами команды.

Вагрант также имеет предопределенные `boxes` которые являются базовыми VM, которые могут быть легко клонированы и расширены.

Еще одна очень интересная особенность Vagrant - использование `synced folders` . Можно синхронизировать папки виртуальной машины с папками на гостевой машине. Делая это, вы можете использовать свой любимый редактор в локальных файлах и одновременно синхронизировать эти файлы с работающей виртуальной машиной.

#### Дополнительная информация:

[Веб-сайт бродяг](https://www.vagrantup.com/)

### Установить бродягу

Чтобы установить Vagrant, сначала найдите [соответствующий пакет](https://www.vagrantup.com/downloads.html) для своей системы и загрузите его. Vagrant упакован как пакет, специфичный для операционной деятельности. Запустите программу установки для вашей системы. Установщик автоматически добавит брандмауэр к вашему системному пути, чтобы он был доступен в терминалах. Если он не найден, попробуйте выполнить регистрацию и войти в систему (это особенно необходимо для Windows).

### Проверить установку

После установки Vagrant проверьте работу установки, открыв новую командную строку или консоль, и убедитесь, что брандмауэр доступен:

```bash
$ vagrant 
 Usage: vagrant [options] <command> [<args>] 
 
    -v, --version                    Print the version and exit. 
    -h, --help                       Print this help. 
 
 # ... 
```

### Начиная

```bash
$ vagrant init hashicorp/precise64 
 $ vagrant up 
```

### Ящики

Коробки добавляются к бродяге с бродячим ящиком. Это сохраняет поле под определенным именем, чтобы несколько бродячих сред могли повторно использовать его. Если вы еще не добавили ящик, вы можете сделать это сейчас:

```bash
$ vagrant box add hashicorp/precise64 
```

### Поиск большего количества ящиков

Лучшее место для поиска большего количества ящиков - [это каталог](https://vagrantcloud.com/boxes/search) ящиков [Vagrant Cloud от HashiCorp](https://vagrantcloud.com/boxes/search) .

### общий

Youtube: [Начало работы с Vagrant](https://www.youtube.com/watch?v=LyIyyFDgO4o) от [Codecourse](https://www.youtube.com/user/phpacademy)

#### Дополнительная информация:

Веб-сайт [бродяг](https://www.vagrantup.com) : [vagrantup.com](https://www.vagrantup.com)