---
title: Yarn
localeTitle: пряжа
---
## пряжа

Пряжа - это менеджер пакетов для вашего кода. Он позволяет использовать и распространять код с другими разработчиками со всего мира. Пряжа делает это быстро, надежно и надежно, поэтому вам никогда не придется беспокоиться о зависимостях проекта.

Пряжа позволяет вам использовать решения других разработчиков для различных проблем, что упрощает разработку вашего программного обеспечения. Если у вас есть проблемы, вы можете сообщить о проблемах или внести свой вклад, и когда проблема будет устранена, вы можете использовать пряжу, чтобы поддерживать ее в актуальном состоянии.

Код разделяется через нечто, называемое пакетом (иногда называемым модулем). Пакет содержит весь совместно используемый код, а также файл package.json, который описывает пакет.

Чтобы использовать пряжу, вы должны сначала установить ее в своей системе. В конце этой статьи есть ссылки, которые помогут вам сделать это независимо от вашей операционной системы.

Когда у вас установлена ​​пряжа, вы можете начать ее использовать. Вот некоторые из наиболее распространенных команд, которые вам понадобятся.

### пряжа Использование

**Запуск нового проекта**
```
yarn init 
```

Команда `yarn init` откроет интерактивную форму для создания проекта пряжи. `yarn init` создает файл `package.json` котором хранится информация о вашем проекте. Эта интерактивная форма откроется со следующими вопросами:
```
name (your-project): 
 version (1.0.0): 
 description: 
 entry point (index.js): 
 git repository: 
 author: 
 license (MIT): 
```

Вы можете либо набрать ответы для каждой опции, либо просто нажать «Ввод», не набрав ничего, чтобы использовать значение по умолчанию или оставить пустым. Вы всегда можете войти в свой любимый текстовый редактор, чтобы изменить файл `package.json` , если это необходимо.

Ваш файл `package.json` должен выглядеть примерно так:
```
{ 
  "name": "your-new-project", 
  "version": "1.0.0", 
  "description": "A description of your new project.", 
  "main": "index.js", 
  "repository": { 
    "url": "https://github.com/your-username/your-new-project", 
    "type": "git" 
  }, 
  "author": "Your Name <your_name@example.com>", 
  "license": "MIT" 
 } 
```

**Добавление зависимости**
```
yarn add [package] 
```

**Модернизация зависимости**
```
yarn upgrade [package] 
```

**Удаление зависимости**
```
yarn remove [package] 
```

**Установка всех зависимостей проекта**
```
yarn install 
```

#### Дополнительная информация:

*   [Сайт пряжи](https://yarnpkg.com)
*   [Пряжа документация](https://yarnpkg.com/en/docs)
*   [Установка пряжи](https://yarnpkg.com/en/docs/install)
*   [Пряжа против npm](https://www.pluralsight.com/guides/node-js/yarn-a-package-manager-for-node-js)