---
title: Ansible
localeTitle: анзибль
---
## анзибль

Ansible - простой в использовании инструмент автоматизации. Ansible может использоваться для автоматизации развертываний, обновлений, безопасности, управления системами, подготовки контейнеров и т. Д. Файлы конфигурации легко управляются файлами YAML, написанными на простом английском языке. Установка проста и благодаря формату Master-Push, на удаленных машинах нет агентов. Связь с удаленными машинами осуществляется через SSH.

### Установка на серверах Ubuntu 14.04 или новее

Рекомендуется установить с помощью Ansible PPA на серверах Ubuntu.

Сначала убедитесь, что ваша система обновлена.
```
$ sudo apt-get update 
 $ sudo apt-get upgrade 
```

Затем вы захотите добавить в свою систему следующий пакет
```
$ sudo apt-get install software-properties-common 
```

Добавьте ppa: ansible / ansible к вашей системе
```
$ sudo apt-add-repository ppa:ansible/ansible 
```

Обновите свои репозитории
```
$ sudo apt-get update 
```

Обычно в развертывании вашего кода в производство (на сайт) есть несколько шагов. Количество шагов увеличивается по мере того, как ваш сайт / приложение / Webapp становится больше и сложнее.

Решением этого является автоматическое развертывание. Автоматизация происходит в виде скриптов, которые действуют как набор инструкций (как и весь код), описывающих каждый из этих шагов.

Ansible - инструмент автоматизации, часто используемый для развертывания, как упоминалось выше, но все чаще используется для других сложных автоматизаций.

Он использует язык под названием [YAML,](https://en.wikipedia.org/wiki/YAML) который позволяет вам описывать установки, близкие к простому английскому, как вы можете видеть в этом примере модуля Ansible:

```YAML
--- 
 - yum: name={{contact.item}} state=installed 
 with_items: 
 - app_server 
 - acme_software 
 
 
 - service: name=app_server state=running enabled=yes 
```

Наконец, установите пакет
```
$ sudo apt-get install ansible 
```

Существенным преимуществом использования Ansible является то, что он использует SSH (Secure SHell) по умолчанию, а модули могут находиться на любом компьютере (компьютере), не требующем серверов, демонов или баз данных.

Истинная сила Ansible заключается в использовании игровых автоматов. Подробнее о настройке и использовании [официальной документации](https://docs.ansible.com/ansible/latest/index.html) Ansible on [Ansible](https://docs.ansible.com/ansible/latest/index.html) .

Необычные модули, которые представляют собой небольшие задачи. После того, как они будут служить там, например, для запуска вашего сценария развертывания, эти модули удаляются Ansible.

#### Дополнительная информация:

*   [Узнайте больше о том, как работает Ansible](https://www.ansible.com/how-ansible-works/)
*   [Незаменимая документация](http://docs.ansible.com/)