---
title: Docker rmi
localeTitle: Docker rmi
---
## Docker rmi

`docker rmi` удаляет изображения по их идентификатору.

Чтобы удалить изображение, сначала необходимо перечислить все изображения, чтобы получить идентификаторы изображений, название изображения и другие данные. Путем выполнения простых команд- `docker images -a` или `docker images` .

После этого вы убедитесь, что изображение нужно удалить, чтобы выполнить эту простую команду `docker rmi <your-image-id>` . Затем вы можете подтвердить, что изображение было удалено или нет, перечислив все изображения и отметьте.

### Удаление нескольких изображений

Существует способ удалить более одного изображения за раз, когда вы хотите удалить несколько определенных изображений. Поэтому для этого сначала получите идентификаторы изображений, просто перечислив изображения, а затем выполните простую последовательную команду.

`docker rmi <your-image-id> <your-image-id> ...`

Идентификаторы записи изображений в команде, а затем пробелы между ними.

### Удалить все изображения одновременно

Чтобы удалить все изображения, для этого есть простая команда. `docker rmi $(docker images -q)`

Здесь в приведенной выше команде есть две команды, первая из которых выполняется в синтаксисе `$()` , и возвращает результаты, которые выполняются в этом синтаксисе. Таким образом, в этом `-q- is a option is used to provide to return the unique IDs,` $ () возвращает результаты идентификаторов изображений, а затем `docker rmi` удаляет все эти изображения.

#### Для дополнительной информации:

*   [Документы Docker CLI: rmi](https://docs.docker.com/engine/reference/commandline/rm/)