---
title: Data Types
localeTitle: Типы данных
---
## Типы данных

В Elixir существует пять основных типов данных: целые числа, поплавки, булевы, атомы и строки. Эти типы данных используются для хранения значений для последующего использования в вашей программе.

### Целые

Целое число является не десятичным числом. Elixir встроил поддержку двоичных, восьмеричных и шестнадцатеричных чисел в виде целых чисел.

```elixir
iex> 1337 
 1337 
```

### Плавает

Поплавок требует десятичной и десятичной цифры. Поплавки поддерживают 64-битную двойную точность и `e` для экспонатов.

```elixir
iex> 27e-100 
 27e-100 
```

### Булевы

Логическое значение является истинным или ложным. В Эликсире все правдиво, за исключением `false` и `nil` . Важно отметить, что булевы являются подтипом атомов Elxir (вы можете проверить значения в IEX, чтобы убедиться сами).

```elixir
iex> true 
 true 
 iex> false 
 false 
 iex> nil 
 nil 
```

### атомы

Атом - это константа, значение которой совпадает с именем. Атомы обычно используются для сообщений о статусе / ошибках внутри кортежа с дополнительной информацией, включенной в строку.

```elixir
iex> {:ok, "Message sent successfully"} 
 {:ok, "Message sent successfully"} 
 iex> {:error, "Message failed to send"} 
 {:error, "Message failed to send"} 
```

### Струны

Строка кодируется UTF-8 и заверяется в двойные кавычки.

```elixir
iex> "freeCodeCamp" 
 "freeCodeCamp" 
```

Строка также является двоичной, вы можете увидеть двоичное представление строки в Elixir, добавив `<> <<0>>` в конец строки. Строка может представлять двоичный код, двоичный файл также может представлять строку.

```elixir
iex> "freeCodeCamp" <> <<0>> 
 <<102, 114, 101, 101, 67, 111, 100, 101, 67, 97, 109, 112, 0>> 
```

#### Больше информации

*   [Hexdocs Atom](https://hexdocs.pm/elixir/Atom.html)
*   [Hexdocs String](https://hexdocs.pm/elixir/String.html)
*   [Hexdocs Integer](https://hexdocs.pm/elixir/Integer.html)
*   [Hexdocs Float](https://hexdocs.pm/elixir/Float.html)