---
title: Erlang Term Storage
localeTitle: Срок хранения Erlang
---
## Срок хранения Erlang

Erlang Term Storage, обычно сокращенная как ETS, представляет собой встроенную в OTP базу данных, она доступна в Elixir и является мощной альтернативой решениям Redis, когда приложение работает на одном узле.

## Быстрый старт

Для создания таблицы ETS сначала необходимо инициализировать таблицу `tableName = :ets.new(:table_otp_name, [])` , как только вы активируете таблицу, которую вы можете: вставлять данные, значения поиска, удалять данные и т. Д.

### Демо-версия ETS в IEX

```elixir
iex(1)> myETSTable = :ets.new(:my_ets_table, []) 
 #Reference<0.1520230345.550371329.65846> 
 iex(2)> :ets.insert(myETSTable, {"favoriteWebSite", "freeCodeCamp"}) 
 true 
 iex(3)> :ets.insert(myETSTable, {"favoriteProgrammingLanguage", "Elixir"}) 
 true 
 iex(4)> :ets.i(myETSTable) 
 <1   > {<<"favoriteProgrammingLanguage">>,<<"Elixir">>} 
 <2   > {<<"favoriteWebSite">>,<<"freeCodeCamp">>} 
 EOT  (q)uit (p)Digits (k)ill /Regexp --> 
```

## Упорство

Таблицы ETS не являются постоянными и уничтожаются, как только процесс, которому он принадлежит, заканчивается. Если вы хотите сохранить данные настойчиво, рекомендуется использовать традиционную базу данных и / или файловое хранилище.

## Случаи применения

Таблицы ETS обычно используются для кэширования данных в приложении, например, данные учетной записи, полученные из базы данных, могут храниться в таблице ETS, чтобы уменьшить количество запросов к базе данных. Другим вариантом использования является ограничение скорости использования функций в веб-приложении. Быстрая скорость чтения и записи ETS делает его отличным для этого. Таблицы ETS являются мощным инструментом для разработки высококонвертируемых веб-приложений при минимально возможной стоимости оборудования.

#### Дополнительная информация:

*   [elixir-lang.org | Библиотеки Erlang (ETS)](https://elixir-lang.org/getting-started/erlang-libraries.html#erlang-term-storage)
*   [erlang.org | ETS](http://erlang.org/doc/man/ets.html)