---
title: Phoenix
localeTitle: Феникс
---
## Что такое Phoenix

Phoenix - это основа веб-разработки, написанная в Elixir и созданная Крисом МакКордом. Эта среда с открытым исходным кодом реализует шаблон MVC на стороне сервера и имеет много общего с другими веб-фреймами, такими как Ruby on Rails или Django для Python. Phoenix была написана с акцентом на дружеские отношения с разработчиками, а также отличная производительность и высокая производительность приложений. В феникс-инфраструктуру входят некоторые очень мощные функции, такие как «каналы» для обработки обмена в реальном времени и Ecto, который является фантастическим инструментом для ORM (Object Relational Mapping).

## Установка Phoenix

Установка Phoenix относительно проста, но прежде чем мы сможем это сделать, нам нужно будет убедиться, что Elixir, менеджер пакетов Hex и Erlang уже работают в нашей системе. На сайте Elixir есть фантастическое [руководство](https://elixir-lang.org/install.html) по [установке](https://elixir-lang.org/install.html) как для Elixir, так и для Erlang. Как только они были успешно настроены, просто запустите:

```shell
$ mix local.hex 
```

Чтобы установить диспетчер пакетов Hex, а затем установить запуск архива Phoenix:

```shell
$ mix archive.install https://github.com/phoenixframework/archives/raw/master/phx_new.ez 
```

## Создание приложения Phoenix:

1.  После установки Phoenix создание приложения прост:

```shell
$ mix phx.new <application_name> 
```

2.  Запуск этой команды с созданием структуры каталогов и всех основных файлов, необходимых с именем _приложения, которое_ вы использовали в предыдущей команде. Затем вам будет предложено установить основные зависимости для приложения, поэтому мы скажем «да».
    
3.  Затем нам будет предложено перейти в каталог проекта:
    

```shell
$ cd <application_name> 
```

4.  По умолчанию Phoenix предполагает, что мы будем использовать PostgreSQL для нашего приложения с именем пользователя и паролем «postgres». Если это не так, вам нужно будет изменить свою конфигурацию - в противном случае все, что нам нужно сделать, это создать нашу базу данных:

```shell
$ mix ecto.create 
```

5.  Наконец, мы запустим наш сервер:

```shell
$ mix phx.server 
```

6.  Теперь перейдите в свой браузер и перейдите на localhost: 4000 и посмотрите страницу приветствия! Поздравляем, у вас есть работающее приложение Phoenix.