---
title: Game Development
localeTitle: Разработка игр
---
## Разработка игр

Разработка игр - это искусство создания игр и описывает дизайн, разработку и выпуск игры. Это может быть концепция генерации, проектирования, сборки, тестирования и выпуска. Пока вы создаете игру, важно подумать об игровой механике, наградах, участии игроков и уровне дизайна.

Разработчиком игры может быть программист, звукорежиссер, художник, дизайнер или многие другие роли, доступные в этой отрасли.

Разработка игр может осуществляться большой студией разработки игр или одним человеком. Он может быть таким же маленьким или большим, как вам нравится. Пока он позволяет игроку взаимодействовать с контентом и способен манипулировать элементами игры, вы можете назвать его «игрой».

Чтобы участвовать в процессе разработки игр, вам не нужно писать код. Художники могут создавать и проектировать активы, в то время как разработчик может сосредоточиться на программировании панели здоровья. Тестер может принять участие, чтобы увидеть, что игра работает так, как ожидалось.

![What first games looked like](https://i.ytimg.com/vi/ePc12V6F0ws/maxresdefault.jpg "Какие первые игры выглядели")

Для решения проблем, связанных с игровыми фреймами, были разработаны инструменты, такие как libGDX и OpenGL. Они помогли разработке игр намного быстрее и проще, предоставляя множество готовых функций и функций. Тем не менее, было еще трудно войти в отрасль или понять структуру для кого-то, исходящего из не-программного фона, обычного случая в сценарии развития игры.

![3D map editor made with OpenGL](https://i.ytimg.com/vi/E0laTeycpB4/maxresdefault.jpg "Редактор 3D-карт, созданный с помощью OpenGL")

Именно тогда были разработаны игровые движки, такие как Construct, Game Maker, Unity и Unreal. Как правило, в двигателе есть все, что было в каркасе, но с более дружелюбным подходом, используя графический интерфейс пользователя (GUI) и помогая в графической разработке игры.

В некоторых случаях, таких как Game Maker и Construct, количество предварительно созданных функций настолько велико, что люди, не имеющие навыков программирования, могут создавать игру с нуля, действительно расширяя сцену и делая доступной игру практически для всех.

### Игровые автоматы

![Unity development screen](http://paulbourke.net/stereographics/Unitystereo/textureplanes.jpg "Экран развития Unity")

Многие разработчики предпочитают разрабатывать игру с использованием Game Development Engine.

Игровые двигатели могут значительно упростить процесс создания игры и позволить разработчикам повторно использовать множество функций. Он также обеспечивает рендеринг для 2D и 3D графики, физики и обнаружения столкновений, звука, сценариев и многое другое.

Некоторые игровые двигатели имеют очень крутую кривую обучения, такую ​​как CryEngine или Unreal Engine. Тем не менее, другие инструменты очень доступны для новичков, а некоторые даже вам не нужны, чтобы писать код для создания вашей игры, например Construct 2.

Unity Game Engine находится где-то посередине, в то время как он дружелюбен к новичкам, некоторые популярные и коммерческие игры были построены с использованием Unity (например, Overcooked, Superhot).

Двигатель BuildBox в основном предназначен для разработки гиперказуальных игр.

### Типичные игровые двигатели

*   CryEngine
*   Unreal Engine
*   Игровой движок Unity
*   Игровой автомат
*   Построить 2 или 3
*   шпагат
*   Источник
*   отмороженное место
*   Buildbox

### Больше информации

*   [Удивительный список ресурсов GameDev](https://github.com/Kavex/GameDev-Resources)
*   [Книги по программированию игр](http://www.fromdev.com/2013/07/game-development-books.html)
*   [Основы libGDX](https://libgdx.badlogicgames.com/)
*   [OpenGL Framework](https://www.opengl.org/)
*   [Построить игровой движок](https://www.scirra.com/)
*   [Игровой движок](https://www.yoyogames.com/gamemaker)
*   [Двигатель Unity3D](https://unity3d.com/pt)
*   [Unreal Engine](https://www.unrealengine.com/en-US/what-is-unreal-engine-4)
*   [BuildBox](https://www.buildbox.com/)