---
title: Difference between Git and GitHub
localeTitle: Разница между Git и GitHub
---
## Разница между Git и GitHub

Git и GitHub - две разные вещи. [Git](https://git-scm.com/) - это [система контроля версий](https://en.wikipedia.org/wiki/Version_control) , а [GitHub](https://github.com/) - это сервис для размещения репозиториев Git и помогает людям сотрудничать в написании программного обеспечения. Однако их часто путают из-за их схожего имени, из-за того, что GitHub строит поверх Git и потому, что многие веб-сайты и статьи не делают разницы между ними достаточно ясными.

![Git не GitHub](https://i.imgur.com/EkjwJdr.png)

### Гит

Git - это система управления распределенной версией. Git отвечает за отслеживание изменений в содержании - обычно это файлы исходного кода.

Для получения дополнительной информации есть [полная статья о Git](https://guide.freecodecamp.org/git) .

### GitHub

GitHub - это компания, которая предоставляет хостинг репозитория Git. Это означает, что они предоставляют готовое решение для размещения репозиториев Git на своих серверах. Это может быть полезно для сохранения резервной копии вашего репозитория (Git отслеживает все изменения, внесенные в ваши файлы с течением времени, репо все еще нуждается в резервном копировании) и иметь централизованное место для хранения и совместного использования кода с другими.

GitHub - это не просто сервис-репозиторий Git, но и [программное обеспечение](https://en.wikipedia.org/wiki/Forge_(software)) . Это означает, что он также обеспечивает [отслеживание проблем](https://en.wikipedia.org/wiki/Issue_tracking_system) , инструменты для [проверки кода](https://en.wikipedia.org/wiki/Code_review) и другие инструменты для взаимодействия с другими людьми и создания программного обеспечения.

GitHub не единственный, кто предоставляет такой сервис. Одним из основных конкурентов является [GitLab](https://gitlab.com) . Подробнее об этом см. В [статье о Git-хостинге](https://guide.freecodecamp.org/git/git-hosting) .
