---
title: Git Aliases
localeTitle: Git Aliases
---
## Git Alias

Git автоматически не выводит вашу команду, если вы вводите ее частично. Если вы не хотите вводить весь текст каждой из команд Git, вы можете легко настроить псевдоним для каждой команды с помощью git config. Вот несколько примеров, которые вы можете настроить:

```shell
$ git config --global alias.co checkout 
 $ git config --global alias.br branch 
 $ git config --global alias.ci commit 
 $ git config --global alias.st status 
```

Это означает, что, например, вместо ввода git commit вам просто нужно ввести git ci. Когда вы продолжаете использовать Git, вы, вероятно, будете часто использовать и другие команды; не стесняйтесь создавать новые псевдонимы.

Этот метод также может быть очень полезен при создании команд, которые, по вашему мнению, должны существовать. Например, чтобы исправить проблему удобства использования, с которой вы столкнулись при непоставлении файла, вы можете добавить свой собственный нестационарный псевдоним в Git:

```shell
$ git config --global alias.unstage 'reset HEAD --' 
```

Это делает следующие две команды эквивалентными:

```shell
$ git unstage fileA 
 $ git reset HEAD fileA 
```

Это кажется немного яснее. Также обычно добавляется последняя команда, например:

```shell
$ git config --global alias.last 'log -1 HEAD' 
```

Таким образом, вы можете легко увидеть последнюю фиксацию:

```shell
$ git last 
 commit 66938dae3329c7aebe598c2246a8e6af90d04646 
 Author: Josh Goebel <dreamer3@example.com> 
 Date:   Tue Aug 26 19:48:51 2008 +0800 
 
    test for current head 
 
    Signed-off-by: Scott Chacon <schacon@example.com> 
```

```shell
$ git config --global alias.st status --short --branch 
```

Когда вы запустите команду `git st` , ваш статус git будет отображаться в хорошем, упорядоченном формате.

### Просмотр, редактирование и удаление псевдонимов

Чтобы просмотреть все псевдонимы, созданные на вашем компьютере, выполните команду:

```shell
cat ~/.gitconfig 
```

Замена `cat` на `nano` позволит вам отредактировать их или полностью удалить.

### Псевдоним для просмотра всех псевдонимов

Чтобы добавить псевдоним, чтобы просмотреть все остальные, созданные на вашем компьютере, добавьте псевдоним

```shell
    git config --global alias.aliases 'config --get-regexp alias' 

```