---
title: Git Bisect
localeTitle: Git Bisect
---
## Git Bisect

Команда `git bisect` помогает найти коммиты, которые добавили определенные изменения в ваш проект. Это особенно полезно, если вам нужно найти, какое изменение ввело ошибку.

Эта команда работает, предоставляя ей «плохую» фиксацию, которая включает в себя ошибку и «хорошую» фиксацию до того, как была введена ошибка. Через двоичный поиск `git bisect` выберет фиксации и попросит вас определить, является ли коммит «хорошим» или «плохим». Это продолжается до тех пор, пока команда не сможет найти точное коммитирование, введшее изменение.

### Команды Bisect

Чтобы начать сеанс bisect, вы сообщите git, чтобы начать сеанс bisect, определить «плохую» версию и определить «хорошую» версию. Предполагая, что текущая фиксация нарушена, но фиксация `4b60707` хороша, вы будете запускать следующее:

```shell
git bisect start 
 git bisect bad 
 git bisect good 4b60707 
```

Git проверит фиксацию между «хорошими» и «плохими» версиями и выведет что-то вроде следующего:
```
Bisecting: 2 revisions left to test after this (roughly 2 steps) 
```

Теперь вы должны сообщить git, если текущая фиксация работает с `git bisect good` или если текущая фиксация нарушена с `git bisect bad` . Этот процесс будет повторяться до тех пор, пока команда не сможет распечатать первый неудачный коммит.

Когда закончите, вы должны очистить сеанс bisect. Это приведет к сбросу HEAD до того, что было до начала сеанса bisect:

```shell
git bisect reset 
```

### Другие источники

*   [Документация Git bisect](https://git-scm.com/docs/git-bisect)