---
title: Git Blame
localeTitle: Git Blame
---
## Git Blame

С `git blame` вы можете видеть, кто изменил то, что в определенном файле, по очереди, что полезно, если вы работаете в команде, а не в одиночку. Например, если строка кода заставляет вас задаться вопросом, почему она есть, вы можете использовать `git blame` и вы узнаете, кого вы должны спросить.

### использование

Вы используете `git blame` следующим образом: `git blame NAME_OF_THE_FILE`

Например: `git blame triple_welcome.rb`

Вы увидите такой вывод:

```shell
0292b580 (Jane Doe      2018-06-18 00:17:23 -0500 1) 3.times do 
 e483daf0 (John Doe      2018-06-18 23:50:40 -0500 2)   print 'Welcome ' 
 0292b580 (Jane Doe      2018-06-18 00:17:23 -0500 3) end 
```

Каждая строка аннотируется с SHA, именем автора и датой последнего фиксации.

### Слияние с Git Blame

Некоторым программистам не нравится слово «винить», из-за негативной коннотации «обвиняют кого-то» приносит с собой. Кроме того, инструмент редко (если вообще когда-либо) используется для того, чтобы обвинять кого-то, а попросить совета или понять историю файла. Поэтому иногда люди используют псевдоним, чтобы сменить `git blame` на то, что звучит немного лучше, например, `git who` , `git history` или `git praise` . Для этого вы просто добавляете псевдоним git следующим образом:

`git config --global alias.history blame`

Вы можете найти более подробную информацию о альясинге команды Git [здесь](../git-alias/index.md) .

### Текстовые редакторские плагины, использующие Git Blame

Есть несколько плагинов для различных текстовых редакторов, которые используют `git blame` . Например, чтобы создать нечто вроде тепловых карт или добавить встроенную информацию для текущей строки, которую вы проверяете. Известным примером является [GitLense](https://gitlens.amod.io/) для VSCode.

### Дальнейшее чтение

*   [Документация Git Blame](https://git-scm.com/docs/git-blame)
*   [дальнейшее чтение об использовании Git Blame](https://corgibytes.com/blog/2016/10/18/git-blame/)