---
title: Git Branch
localeTitle: Git Branch
---
## Git Branch

Функциональность разветвления Git позволяет создавать новые ветви проекта для тестирования идей, изоляции новых функций или экспериментов без влияния на основной проект.

**Оглавление**

*   [Посмотреть ветви](#view-branches)
*   [Оформить заказ](#checkout-a-branch)
*   [Создать новый филиал](#create-a-new-branch)
*   [Переименовать ветвь](#rename-a-branch)
*   [Удалить ветвь](#delete-a-branch)
*   [Сравнить филиалы](#compare-branches)
*   [Помощь с Git Branch](#help-with-git-branch)
*   [Дополнительная информация](#more-information)

### Посмотреть ветви

Чтобы просмотреть ветви в репозитории Git, выполните команду:

```shell
git branch 
```

Чтобы просмотреть ветви удаленного отслеживания и локальные ветви, выполните команду:

```shell
git branch -a 
```

Рядом с веткой будет звездочка (\*), в которой вы сейчас находитесь.

Существует множество различных опций, которые вы можете включить в `git branch` для просмотра различной информации. Для получения дополнительной информации о филиалах вы можете использовать опцию `-v` (или `-vv` или `--verbose` ). Список филиалов будет включать значение SHA-1 и строку темы фиксации для `HEAD` каждой ветки рядом с ее именем.

Вы можете использовать параметр `-a` (или `--all` ), чтобы показывать локальные ветви, а также любые удаленные ветви для хранилища. Если вы хотите видеть только удаленные ветви, используйте параметр `-r` (или `--remotes` ).

### Оформить заказ

Чтобы проверить существующую ветку, выполните команду:

```shell
git checkout BRANCH-NAME 
```

Как правило, Git не позволит вам проверять другую ветку, если ваш рабочий каталог не является чистым, потому что вы потеряете любые изменения рабочего каталога, которые не были выполнены. У вас есть три варианта обработки ваших изменений: 1) уничтожить их (см. [Git checkout для деталей](https://guide.freecodecamp.org/git/git-checkout/) ) или 2) совершить их (см. [Git commit для деталей](https://guide.freecodecamp.org/git/git-commit/) ) или 3) спрячьте их (см. [Git stash для деталей](https://guide.freecodecamp.org/git/git-stash/) ).

### Создать новый филиал

Чтобы создать новую ветку, выполните команду:

```shell
git branch NEW-BRANCH-NAME 
```

Обратите внимание, что эта команда создает только новую ветку. Вам нужно будет запустить `git checkout NEW-BRANCH-NAME` чтобы переключиться на него.

Есть ярлык для создания и проверки новой ветки сразу. Вы можете передать опцию `-b` (для филиала) с помощью `git checkout` . Следующие команды выполняют одно и то же:

```shell
# Two-step method 
 git branch NEW-BRANCH-NAME 
 git checkout NEW-BRANCH-NAME 
 
 # Shortcut 
 git checkout -b NEW-BRANCH-NAME 
```

Когда вы создадите новую ветку, она будет включать все фиксации из родительской ветви. Родительская ветвь - это ветка, в которой вы работаете, когда вы создаете новую ветку.

### Переименовать ветвь

Чтобы переименовать ветвь, выполните команду:

```shell
git branch -m OLD-BRANCH-NAME NEW-BRANCH-NAME 
 
 # Alternative 
 git branch --move OLD-BRANCH-NAME NEW-BRANCH-NAME 
```

### Удалить ветвь

Git не позволит вам удалить ветку, в которой вы сейчас находитесь. Сначала вам нужно проверить другую ветку, а затем запустить команду:

```shell
git branch -d BRANCH-TO-DELETE 
 
 # Alternative: 
 git branch --delete BRANCH-TO-DELETE 
```

Ветвь, с которой вы переключаетесь, имеет значение. Git выдаст ошибку, если изменения в ветке, которую вы пытаетесь удалить, не полностью объединены в текущую ветку. Вы можете переопределить это и заставить Git удалить ветку с `-D` вариант (обратите внимание на заглавную букву) или используя `--force` опцию `-d` или `--delete` :

```shell
git branch -D BRANCH-TO-DELETE 
 
 # Alternatives 
 git branch -d --force BRANCH-TO-DELETE 
 git branch --delete --force BRANCH-TO-DELETE 
```

### Сравнить филиалы

Вы можете сравнивать ветви с командой `git diff` :

```shell
git diff FIRST-BRANCH..SECOND-BRANCH 
```

Вы увидите цветной выход для изменений между ветвями. Для всех строк, которые изменились, версия `SECOND-BRANCH` будет зеленой строкой, начинающейся с «+», а версия `FIRST-BRANCH` будет красной линией, начинающейся с «-». Если вы не хотите, чтобы Git отображал две строки для каждого изменения, вы можете использовать опцию `--color-words` . Вместо этого Git покажет одну строку с удаленным текстом красного цвета и добавит текст в зеленый цвет.

Если вы хотите увидеть список всех ветвей, которые полностью объединены в вашу текущую ветку (другими словами, ваша текущая ветка включает в себя все изменения остальных ветвей, которые перечислены), запустите команду `git branch --merged` .

### Помощь с Git Branch

Если вы забыли, как использовать параметр, или хотите изучить другие функции вокруг команды `git branch` , вы можете запустить любую из этих команд:

```shell
git help branch 
 git branch --help 
 man git-branch 
```

### Дополнительная информация:

*   Команда `git merge` : [руководство FCC](https://guide.freecodecamp.org/git/git-merge/)
*   Команда `git checkout` : [руководство FCC](https://guide.freecodecamp.org/git/git-checkout/)
*   Команда `git commit` : [руководство FCC](https://guide.freecodecamp.org/git/git-commit/)
*   Команда `git stash` : [руководство FCC](https://guide.freecodecamp.org/git/git-stash/)
*   Документация Git: [ветвь](https://git-scm.com/docs/git-branch)