---
title: Git Checkout
localeTitle: Git Checkout
---
## Git Checkout

Команда `git checkout` позволяет переключаться между ветками проекта или отменять изменения внесенные в файлы проекта. Для этой команды существует несколько различных вариантов, которые здесь не рассматриваются, но вы можете посмотреть их все в [документации Git](https://git-scm.com/docs/git-checkout) .

### Переключение на конкретный коммит

для того, чтобы переключиться на конкретный коммит выполните команду:

```shell
git checkout specific-commit-id 
```

мы можем найти конкретный идентификатор коммита выполнив следующую команду:

```shell
git log 
```

### Переключение на существующую ветку

Для того, чтобы переключиться на существующую ветку необходимо выполнить команду:

```shell
git checkout BRANCH-NAME 
```

Как правило, Git не позволит вам переключиться на другую ветку, если вы внесли изменения в рабочий каталог, потому что вы потеряете любые изменения рабочего каталога, которые не были зафиксированы. У вас есть три варианта обработки ваших изменений: 1) уничтожить их, 2) [зафиксировать их](https://guide.freecodecamp.org/git/git-commit/) или 3) [спрятать их](https://guide.freecodecamp.org/git/git-stash/) .

### Переключение на новую ветку

Чтобы создать и переключиться на новую ветку с помощью одной команды, вы можете выполнить команду:

```shell
git checkout -b NEW-BRANCH-NAME 
```

Это автоматически переключит вас на новую ветку.

### Переключеться на новую ветку или Сбросить ветку в начальную точку

Следующая команда похожа на команду переключения на новую ветку, но использует флаг `-B` (прописная B) и необязательный параметр `START-POINT` :

```shell
git checkout -B BRANCH-NAME START-POINT 
```

Если ветка `BRANCH-NAME` не существует, Git создаст ее и запустит ее в `START-POINT` . Если ветка `BRANCH-NAME` уже существует, Git сбрасывает ветку до `START-POINT` . Это эквивалентно запуску `git branch` с флагом `-f` .

### Принудительное переключение

Вы можете передать параметр `-f` или `--force` командой `git checkout` чтобы заставить Git переключать ветки, даже если у вас есть изменения которые не были зафиксированы (другими словами, индекс рабочего дерева отличается от `HEAD` ). В принципе, его можно использовать для отмены локальных изменений.

Когда вы запускаете следующую команду, Git будет игнорировать локальные изменения:

```shell
git checkout -f BRANCH-NAME 
 
 # Альтернатива 
 git checkout --force BRANCH-NAME 
```

### Отменить изменения в рабочем каталоге

Вы можете использовать команду `git checkout` чтобы отменить изменения, внесенные вами в файл в вашем рабочем каталоге. Это вернет файл обратно в версию в `HEAD` :

```shell
git checkout -- FILE-NAME 

```
