---
title: Git Cherry Pick
localeTitle: Git Cherry Pick
---
## Git Cherry Pick

Команда `git cherry-pick` применяет изменения, внесенные в некоторые существующие коммиты. Это руководство будет сосредоточено на разъяснении этой функции как можно больше, но, конечно, настоящая [документация Git](https://git-scm.com/docs/git-cherry-pick) всегда будет полезна.

### Оформить покупку существующего отделения Cherry Pick от мастера

Чтобы применить изменение, внесенное фиксацией на конце ведущей ветки, и создать новое коммитирование с этим изменением. Выполните следующую команду

```shell
git cherry-pick master 
```

### Проверьте изменения с другой фиксации

Чтобы применить изменения, внесенные фиксацией, в нужное значение хэша, выполните следующую команду

```shell
git cherry-pick {HASHVALUE} 
```

Это добавит изменения, включенные в эту фиксацию, в ваш текущий репозиторий

### Применить определенные коммиты от одной ветви к другой

`cherry-pick` позволяет выбирать между фиксациями из одной ветви одной в другую. Допустим, у вас есть две ветви `master` и `develop-1` . В ветви `develop-1` вас есть 3 фиксации с фиксацией `commit-1` , `commit-2` и `commit-3` . Здесь вы можете применить `commit-2` к `master` серверу:

```shell
git checkout master 
 git cherry-pick commit-2 
```

Если вы столкнулись с конфликтами на этом этапе, вы должны исправить их и добавить их с помощью `git add` а затем вы можете использовать флаг continue, чтобы применить вишневый выбор.

```shell
git cherry-pick --continue 
```

Если вы хотите прервать выбор вишни между вами, вы можете использовать флаг abort:

```shell
git cherry-pick --abort 

```