---
title: Git Clone
localeTitle: Git Clone
---
## Git Clone

Команда `git clone` позволяет скопировать удаленный репозиторий на локальную машину.

Во-первых, найдите удаленный репозиторий для проекта, над которым вы работаете или заинтересованы, - это также может быть вашей вилкой проекта. Затем скопируйте URL-адрес для него. Например, если вы разветвляли репозиторий справочников freeCodeCamp, URL-адрес выглядит как `https://github.com/YOUR-GITHUB-USERNAME/guides.git` .

В командной строке на вашем локальном компьютере перейдите туда, где вы хотите сохранить проект в своем рабочем каталоге. Наконец, запустите команду `git clone` :

```shell
git clone URL-OF-REPOSITORY 
```

По умолчанию имя нового каталога на вашем компьютере - это имя репозитория, но вы можете изменить его, включив последний (дополнительный) параметр:

```shell
git clone URL-OF-REPOSITORY NAME-OF-DIRECTORY-ON-COMPUTER 
```

Git дает удаленному псевдониму «происхождение». Это полезный способ обратиться к удаленному устройству, если вы хотите направить свои изменения на удаленный сервер или вытащить из него изменения. См. [Git push](https://guide.freecodecamp.org/git/git-push/) и [Git pull](https://guide.freecodecamp.org/git/git-pull/) для получения более подробной информации.

Git только тянет основную ветвь пульта на ваш компьютер. Эта ветка обычно называется «хозяин» по соглашению, но может быть определена по-разному в зависимости от проекта.

Кроме того, Git автоматически настраивает локальную основную ветвь для отслеживания удаленной ветви. Когда вы запустите `git status` , вы увидите информацию о том, обновлена ​​ли ваша локальная ветка с помощью пульта. Вот пример вывода:

```shell
myCommandPrompt (master) >> git status 
 On branch master 
 Your branch is up-to-date with 'origin/master'. 
 nothing to commit, working tree clean 
 myCommandPrompt (master) >> 
```

Если ваш локальный `master` ветвь имеет три фиксации, которые вы еще не нажали на удаленный сервер, статус будет гласить: «Ваша ветка впереди« источник / хозяин »на 3 фиксации».

### Зеркало Git Clone

Если вы хотите разместить зеркало репозитория, вы можете использовать зеркальный параметр.

```shell
git clone URL-OF-REPOSITORY --mirror 
```

После зеркалирования репозитория вы можете клонировать локальное зеркало со своего сервера.

```shell
git clone NAME-OF-DIRECTORY-ON-COMPUTER 
```

### Дополнительная информация:

*   Документация Git: [клон](https://git-scm.com/docs/git-clone)