---
title: Git Commit
localeTitle: Git Commit
---
## Git Commit

Команда `git commit` сохранит все поэтапные изменения вместе с кратким описанием пользователя в «commit» в локальном репозитории.

Обязательства лежат в основе использования Git. Вы можете подумать о фиксации в виде моментального снимка вашего проекта, где новая версия этого проекта создается в текущем репозитории. Две важные особенности совершения:

*   вы можете вспомнить внесенные изменения позднее или вернуться к этой версии ( [см. Git checkout](https://guide.freecodecamp.org/git/git-checkout) )
*   если несколько коммитов редактируют разные части проекта, они не будут перезаписывать друг друга, даже если авторы сообщения не знали друг о друге. Это одно из преимуществ использования Git над инструментом, например Dropbox или Google Диском.

### Опции

Существует ряд опций, которые вы можете включить в `git commit` . Однако это руководство будет охватывать только два наиболее распространенных варианта. Для получения обширного списка вариантов обратитесь к [документации Git](https://git-scm.com/docs/git-commit) .

#### Опция -m

Наиболее распространенным вариантом использования `git commit` является опция `-m` . `-m` означает сообщение. При вызове `git commit` требуется включить сообщение. Сообщение должно содержать краткое описание совершенных изменений. Сообщение должно быть в конце команды, и оно должно быть заключено в котировки `" "` .

Пример использования опции `-m` :

```shell
git commit -m "My message" 
```

Результат в вашем терминале должен выглядеть примерно так:

```shell
[master 13vc6b2] My message 
 1 file changed, 1 insertion(+) 
```

**ПРИМЕЧАНИЕ.** Если `-m` не включен в команду `git commit` , вам будет предложено добавить сообщение в текстовый редактор по умолчанию - см. «Использование подробных сообщений коммита» ниже.

#### Опция -a

Другим популярным вариантом является опция `-a` . `-a` означает все. Этот параметр автоматически ставит все измененные файлы, которые должны быть зафиксированы. Если новые файлы добавлены, опция `-a` не будет создавать эти новые файлы. Будут зафиксированы только файлы, хранящиеся в репозитории Git.

Например:

Допустим, у вас есть файл `README.md` , который уже был `README.md` к вашему репозиторию. Если вы вносите изменения в этот файл, вы можете использовать опцию `-a` в своей команде commit для создания и добавления изменений в ваш репозиторий. Однако, что, если вы также добавили новый файл `index.html` ? Параметр `-a` не будет `index.html` поскольку он в настоящее время не существует в репозитории. Когда новые файлы были добавлены, необходимо `git add` команду `git add` для того, чтобы сгенерировать файлы, прежде чем они смогут быть привязаны к репозиторию.

Пример использования опции `-a` :

```shell
git commit -am “My new changes” 
```

Результат в вашем терминале должен выглядеть примерно так:

```shell
[master 22gc8v1] My new message 
 1 file changed, 1 insertion(+) 
```

### Использование подробных сообщений о фиксации

Хотя `git commit -m "commit message"` работает просто отлично, может быть полезно предоставить более подробную и статистическую информацию.

Если вы зафиксируете без использования опции `-m` , git откроет текстовый редактор по умолчанию с новым файлом, который будет включать в себя список всех файлов / изменений, которые помещаются в коммит. Затем вы пишете свое подробное сообщение о фиксации (первая строка будет обрабатываться как строка темы), и фиксация будет выполняться при сохранении / закрытии файла.

Имей в виду:

*   В качестве стандартной практики держите свои строки сообщений с фиксацией менее 72 символов
*   Совершенно нормально и даже рекомендуется писать многострочные сообщения фиксации
*   Вы также можете ссылаться на другие проблемы или тянуть запросы в сообщении о фиксации. GitHub выделил номер ссылки на все запросы и проблемы с pull, поэтому, например, если вы хотите ссылаться на запрос на тяну # 788, просто сделайте это либо в строке темы, либо в основном тексте в соответствующих случаях

#### Опция --amend

Параметр `--amend` позволяет вам изменить свой последний `--amend` . Допустим, вы только что совершили ошибку, и вы сделали ошибку в своем сообщении журнала транзакций. Вы можете легко изменить последнюю фиксацию с помощью команды:

```shell
git commit --amend -m "an updated commit message" 
```

Если вы забыли включить файл в commit:

```shell
git add FORGOTTEN-FILE-NAME 
 git commit --amend -m "an updated commit message" 
 
 # If you don't need to change the commit message, use the --no-edit option 
 git add FORGOTTEN-FILE-NAME 
 git commit --amend --no-edit 
```

Преждевременные совершения происходят все время в ходе вашего ежедневного развития. Легко забыть создать файл или правильно отформатировать сообщение фиксации. Флаг `--amend` - это удобный способ исправить эти незначительные ошибки. Эта команда заменит старое сообщение фиксации на обновленное, указанное в команде.

Исправленные коммиты - это совершенно новые коммиты, и предыдущая фиксация больше не будет в вашей текущей ветке. Когда вы работаете с другими, вы должны стараться избегать внесения изменений в коммиты, если последняя фиксация уже помещена в репозиторий.

С помощью `--amend` одним из полезных флагов, которые вы можете использовать, является `--author` который позволяет вам изменить автора последней сделанной вами фиксации. Представьте себе ситуацию, когда вы неправильно настроили свое имя или адрес электронной почты в git-конфигурациях, но вы уже совершили коммит. С флагом `--author` вы можете просто изменить их без сброса последнего фиксации.
```
git commit --amend --author="John Doe <johndoe@email.com>" 
```

#### Опция -v или --verbose

Опция `-v` или `--verbose` используется без опции `-m` . Опция `-v` может быть полезна, когда вы хотите отредактировать сообщение Git commit в редакторе по умолчанию, имея возможность видеть изменения, сделанные вами для фиксации. Команда открывает текстовый редактор по умолчанию с шаблоном сообщения фиксации, _а также_ копию изменений, сделанных вами для этой фиксации. Изменения или diff не будут включены в сообщение фиксации, но они обеспечивают хороший способ ссылаться на ваши изменения, когда вы описываете их в своем сообщении о фиксации.

### Дополнительная информация:

*   Документация Git: [commit](https://git-scm.com/docs/git-commit)