---
title: Git Log
localeTitle: Git Log
---
## Git Log

Команда `git log` отображает все записи в истории репозитория.

По умолчанию команда отображает каждый фиксатор:

*   Алгоритм безопасного хеша (SHA)
*   автор
*   Дата
*   сообщение фиксации

### Навигация по Git Log

Git использует терминальный пейджер Less, чтобы просмотреть историю фиксации. Вы можете перемещаться по ним со следующими командами:

*   для прокрутки вниз по одной строке используйте j или ↓
*   для прокрутки вверх по одной строке используйте k или ↑
*   для прокрутки вниз по одной странице используйте пробел или кнопку «Вниз»
*   для прокрутки вверх на одну страницу используйте кнопку b или кнопку «Страница вверх»
*   для выхода из журнала используйте q

### Флаги журнала Git

Вы можете настроить информацию, представленную `git log` используя флаги.

#### \--одна линия

`git log --oneline`

Флаг `--oneline` вызывает отображение `git log`

*   одна фиксация на линию
*   первые семь символов SHA
*   сообщение фиксации

#### \--stat

`git log --stat`

Флаг `--stat` вызывает отображение `git log`

*   файлы, которые были изменены в каждой фиксации
*   количество добавленных или удаленных линий
*   итоговая строка с общим количеством файлов и строк изменена

#### \--patch или -p

`git log --patch`

или, более короткая версия

`git log -p`

Флаг `--patch` вызывает отображение `git log`

*   файлы, которые вы изменили
*   расположение линий, которые вы добавили или удалили
*   конкретные изменения, которые вы внесли

### Просмотреть указанное количество записей по автору

Чтобы просмотреть указанное количество коммитов автором для текущего репо (необязательно в префиксном формате), можно использовать следующую команду

`git log --pretty=format:"%Cred%h%Creset -%C(yellow)%d%Creset %s %Cgreen(%cr) %C(bold blue)<%an>%Creset" -n {NUMBER_OF_COMMITS} --author="{AUTHOR_NAME}" --all`

#### Начните с определенного коммита

Чтобы запустить `git log` при определенном коммите, добавьте SHA:

`git log 7752b22`

Это покажет фиксацию с SHA 7752b22 и всеми коммитами, сделанными до этого фиксации. Вы можете комбинировать это с любым другим флагом.

#### \--graph

`git log --graph`

Флаг `--graph` позволяет вам просматривать ваш `git log` в виде графика. Чтобы сделать что-то интересное, вы можете комбинировать эту команду с опцией `--oneline` вы узнали выше.

`git log --graph --oneline`

Результат будет аналогичен,
```
* 64e6db0 Update index.md 
 * b592012 Update Python articles (#5030) 
 * ecbf9d3 Add latest version and remove duplicate link (#8860) 
 * 7e3934b Add hint for Compose React Components (#8705) 
 * 99b7758 Added more frameworks (#8842) 
 * c4e6a84 Add hint for "Create a Component with Composition" (#8704) 
 *   907b004 Merge branch 'master' of github.com:freeCodeCamp/guide 
 |\ 
 | * 275b6d1 Update index.md 
 * |   cb74308 Merge branch 'dogb3rt-patch-3' 
 |\ \ 
 | |/ 
 |/| 
 | *   98015b6 fix merge conflicts after folder renaming 
 | |\ 
 |/ / 
 | * fa83460 Update index.md 
 * | 6afb3b5 rename illegally formatted folder name (#8762) 
 * | 64b1fe4 CSS3: border-radius property (#8803) 
```

Одним из преимуществ использования этой команды является то, что она позволяет вам получить обзор того, как коммиты слились и как была создана история git.

Существуют и другие варианты, которые вы могли бы использовать в сочетании с `--graph` . Пара из них `--decorate` и `--all` . Обязательно попробуйте тоже. И обратитесь к [документу](https://git-scm.com/docs/git-log) для получения более полезной информации.

#### Дополнительная информация:

*   [Основы Git - просмотр истории фиксации](https://git-scm.com/book/en/v2/Git-Basics-Viewing-the-Commit-History)
*   [Git Log](https://git-scm.com/docs/git-log)

##### Другие ресурсы на Git в guide.freecodecamp.org

*   [Git Merge](../git-merge/index.md)
*   [Git Checkout](../git-checkout/index.md)
*   [Git Commit](../git-commit/index.md)
*   [Git Stash](../git-stash/index.md)
*   [Git Branch](../git-branch/index.md)