---
title: Git Pull
localeTitle: Git Pull
---
## Git Pull

`git pull` - это команда Git, используемая для обновления локальной версии репозитория с удаленного устройства.

Это одна из четырех команд, которые запрашивают сетевое взаимодействие Git. По умолчанию `git pull` делает две вещи.

1.  Обновляет текущую локальную рабочую ветвь (в настоящее время проверяется ветвь)
2.  Обновляет ветви удаленного отслеживания для всех остальных ветвей.

`git pull` fetches ( `git fetch` ) новые коммиты и слияния [( `git merge` )](https://guide.freecodecamp.org/git/git-merge) в вашу локальную ветвь.

Синтаксис этой команды следующий:

```shell
# General format 
 git pull OPTIONS REPOSITORY REFSPEC 
 
 # Pull from specific branch 
 git pull REMOTE-NAME BRANCH-NAME 
```

в котором:

*   **Опциями** являются параметры команды, такие как `--quiet` или `--verbose` . Вы можете больше узнать о различных параметрах в [документации Git](https://git-scm.com/docs/git-pull)
*   **REPOSITORY** - это URL вашего репо. Пример: https://github.com/freeCodeCamp/freeCodeCamp.git
*   **REFSPEC** указывает, какие ссылки на выборку и какие локальные ссылки обновлять
*   **REMOTE-NAME** - это имя вашего удаленного репозитория. Например: _происхождение_ .
*   **ФИО ФИНАНСИРОВАНИЯ** - это название вашего филиала. Например: _разработать_ .

**Заметка**

Если у вас есть незафиксированные изменения, часть слияния команды `git pull` не удастся, и ваша локальная ветка останется нетронутой.

Таким образом, вы должны _всегда фиксировать свои изменения в ветке, прежде чем вытаскивать_ новые коммиты из удаленного репозитория.

**Оглавление**

*   [Использование `git pull`](#using-git-pull)
*   [Управление распределенной версией](#distributed-version-control)
*   [`git fetch` + `git merge`](#git-fetch-plus-git-merge)
*   [`git pull` in IDE](#git-pull-in-IDEs)

### Использование git pull

Используйте `git pull` для обновления локального репозитория из соответствующего удаленного репозитория. Пример: при работе локально на `master` , выполните `git pull` чтобы обновить локальную копию `master` и обновить другие удаленные ветви отслеживания. (Дополнительная информация о филиалах удаленного отслеживания приведена в следующем разделе.)

Но есть несколько вещей, которые следует помнить, чтобы этот пример был правдой:

*   В локальном репозитории имеется связанный удаленный репозиторий
*   Проверьте это, выполнив `git remote -v`
*   Если есть несколько пультов, `git pull` может быть недостаточно информации. Возможно, вам понадобится ввести `git pull origin` или `git pull upstream` .
*   В филиале, в котором вы сейчас находитесь, имеется соответствующая ветвь удаленного отслеживания
*   Проверьте это, выполнив `git status` . Если нет удаленного филиала отслеживания, Git не знает , куда извлекать информацию _из._

### Управление распределенной версией

Git - это **система управления распределенной версией** (DVCS). С помощью DVCS разработчики могут работать в одном файле одновременно в отдельных средах. После _нажатия_ кода на общий удаленный репозиторий другие разработчики могут _вытащить_ измененный код.

#### Сетевые взаимодействия в Git

Есть только четыре команды, которые подсказывают сетевые взаимодействия в Git. Локальный репозиторий не знает об изменениях, внесенных в удаленный репозиторий, пока не появится запрос на получение информации. И удаленный репозиторий не осознает локальные изменения до тех пор, пока не будет нажата фиксация.

Четыре команды сети:

*   `git clone`
*   `git fetch`
*   `git pull`
*   `git push`

#### Филиалы в DVCS

Когда вы работаете с Git, может показаться, что есть много копий одного и того же кода, плавающих по всему месту. На каждой ветке есть разные версии одного и того же файла. И разные копии тех же филиалов на каждом компьютере разработчика и на пульте дистанционного управления. Чтобы отслеживать это, Git использует что-то, называемое **ветками удаленного отслеживания** .

Если вы выполняете `git branch --all` в репозитории Git, удаленные ветви отслеживания отображаются красным цветом. Это копии только для чтения кода, которые отображаются на пульте дистанционного управления. (Когда было последним сетевым взаимодействием, которое могло бы привести информацию локально? Помните, когда эта информация была обновлена ​​в последний раз. Информация в ветках удаленного отслеживания отражает информацию об этом взаимодействии.)

С **удаленными ветвями отслеживания** вы можете работать в Git на нескольких ветвях без сетевого взаимодействия. Каждый раз, когда вы выполняете команды `git pull` или `git fetch` , вы обновляете **ветви удаленного отслеживания** .

### git fetch plus git merge

`git pull` - это комбинационная команда, равная `git fetch` + `git merge` .

#### git fetch

Сам по себе `git fetch` обновляет все ветви удаленного отслеживания в локальном репозитории. Никакие изменения не отражаются ни на одной из местных рабочих отраслей.

#### git merge

Без каких-либо аргументов `git merge` объединит соответствующую ветвь удаленного отслеживания в локальную рабочую ветвь.

#### git pull

`git fetch` обновляет удаленные ветви отслеживания. `git merge` обновляет текущую ветку с соответствующей ветвью удаленного отслеживания. Используя `git pull` , вы получаете обе части этих обновлений. Но это означает, что если вы проверили, чтобы `feature` ветку, и вы выполняете `git pull` , когда вы выходите на `master` , любые новые обновления не будут включены. Всякий раз, когда вы проверяете другую ветку, которая может иметь новые изменения, всегда рекомендуется выполнять `git pull` .

### git pull in IDE

Общий язык в других IDES может не включать слово `pull` . Если вы ищете слова `git pull` но не видите их, найдите вместо этого `sync` слов.

### запуская удаленный PR (Pull Request) в локальное репо

Для целей пересмотра и т. Д. ОР в удаленном режиме должны быть отправлены на местное репо. Для достижения этой цели вы можете использовать команду `git fetch` .

`git fetch origin pull/ID/head:BRANCHNAME`

ID - идентификатор запроса pull, а BRANCHNAME - это название ветки, которую вы хотите создать. После того, как филиал был создан, вы можете использовать `git checkout` для переключения на этот бит.

### Другие ресурсы по git pull

*   [ГИТ-СКМ](https://git-scm.com/docs/git-pull)
*   [Документы справки GitHub](https://help.github.com/articles/fetching-a-remote/#pull)
*   [Обучение GitHub по требованию](https://services.github.com/on-demand/intro-to-github/create-pull-request)
*   [Синхронизация учебников](https://www.atlassian.com/git/tutorials/syncing)

### Другие ресурсы по git в guide.freecodecamp.org

*   [Git merge](../git-merge/index.md)
*   [Git checkout](../git-checkout/index.md)
*   [Git commit](../git-commit/index.md)
*   [Скрытый текст](../git-stash/index.md)
*   [Git branch](../git-branch/index.md)