---
title: Git Push
localeTitle: Git Push
---
## Git Push

Команда `git push` позволяет отправлять (или _нажимать_ ) коммиты из локальной ветви в локальный репозиторий Git в удаленный репозиторий.

Чтобы иметь возможность нажать на ваш удаленный репозиторий, вы должны убедиться, что **все ваши изменения в локальном репозитории совершены** .

Синтаксис этой команды следующий:

```bash
git push <repo name> <branch name> 
```

Существует несколько различных параметров, которые вы можете передать с помощью команды, вы можете узнать больше о них в [документации Git](https://git-scm.com/docs/git-push#_options_a_id_options_a) или запустить `git push --help` .

### Нажмите на конкретный удаленный репозиторий и ветвь

Чтобы продвигать код, вы должны сначала клонировать репозиторий на свой локальный компьютер.

```bash
# Once a repo is cloned, you'll be working inside of the default branch (the default is `master`) 
 git clone https://github.com/<git-user>/<repo-name> && cd <repo-name> 
 # make changes and stage your files (repeat the `git add` command for each file, or use `git add .` to stage all) 
 git add <filename> 
 # now commit your code 
 git commit -m "added some changes to my repo!" 
 # push changes in `master` branch to github 
 git push origin master 
```

Чтобы узнать больше о филиалах, ознакомьтесь с приведенными ниже ссылками:

*   [git checkout](https://github.com/renington/guides/blob/master/src/pages/git/git-checkout/index.md)
*   [гит-ветвь](https://github.com/renington/guides/blob/master/src/pages/git/git-branch/index.md)

### Нажмите на конкретный удаленный репозиторий и все ветви в нем.

Если вы хотите переместить все свои изменения в удаленный репозиторий и все ветви в нем, вы можете использовать:

```bash
git push --all <REMOTE-NAME> 
```

в котором:

*   `--all` - это флаг, который сигнализирует, что вы хотите направить все ветви в удаленный репозиторий
*   `REMOTE-NAME` - это имя удаленного репозитория, на который вы хотите нажать

### Нажмите на конкретную ветвь с параметром силы

Если вы хотите игнорировать локальные изменения, внесенные в репозиторий Git в GitHub (что большинство разработчиков делают для горячего исправления для сервера разработки), вы можете использовать команду -force для прогона, игнорируя эти изменения.

```bash
git push --force <REMOTE-NAME> <BRANCH-NAME> 
```

в котором:

*   `REMOTE-NAME` - это имя удаленного репозитория, для которого вы хотите
*   `BRANCH-NAME` - это имя удаленного отделения, на которое вы хотите

### Нажимать игнорирование предварительного нажатия Git

По умолчанию `git push` запускает `--verify` toggle. Это означает, что git выполнит любой клиентский предварительный сценарий, который может быть настроен. Если сценарии предварительного толчка не пройдут, то будет и git push. (Крючки Pre-Push подходят для таких вещей, как проверка, подтверждают ли сообщения фиксации стандартам компании, запускают тесты модулей и т. Д.). Иногда вы можете игнорировать это поведение по умолчанию, например, в сценарии, в котором вы хотите направить свои изменения в ветку функций для другого вкладчика, но ваши изменения в незавершенном производстве прерывают модульные тесты. Чтобы игнорировать hook, просто введите команду push и добавьте флаг `--no-verify`

```bash
git push --no-verify 
```

### Дополнительная информация:

*   [Документация Git - нажмите](https://git-scm.com/docs/git-push)
*   [Git hooks](https://git-scm.com/book/en/v2/Customizing-Git-Git-Hooks)
