---
title: Git Squash
localeTitle: Git Squash
---
## Git Squash

Одна из вещей, которые разработчики часто слышат в отношении своих запросов на подачу, - это что-то вроде «Это выглядит хорошо для меня, пожалуйста, сквош и слияние». Самое интересное, что нет такой команды, как `git squash` (если вы не создадите для нее [псевдоним](https://guide.freecodecamp.org/git/git-rebase) ). Чтобы запросить `squash` pull, обычно можно скомпоновать все коммиты в этом запросе на один (редко на другой номер), чтобы сделать его более кратким, удобочитаемым и не загрязнять историю основного филиала. Для достижения этого разработчика необходимо использовать **интерактивный режим** команды [Git Rebase](https://guide.freecodecamp.org/git/git-rebase) .

Довольно часто, когда вы разрабатываете новую функцию, вы получаете несколько прерывистых задержек в своей истории - вы постепенно развиваетесь. Это может быть всего лишь опечатки или шаги к окончательному решению. Большую часть времени нет смысла использовать все эти коммиты в окончательной публичной версии кода, поэтому выгоднее всего их объединить в один, один и последний.

Итак, давайте предположим, что у вас есть следующий журнал фиксации в ветке, которую вы хотели бы объединить как часть запроса на pull:

```shell
$ git log --pretty=oneline --abbrev-commit 
 30374054 Add Jupyter Notebook stub to Data Science Tools 
 8490f5fc Minor formatting and Punctuation changes 
 3233cb21 Prototype for Notebook page 
```

Ясно, что мы предпочли бы иметь только одну фиксацию здесь, поскольку нет никакой пользы в том, чтобы знать, что мы начали писать, и какие опечатки мы исправили там позже, имеет значение только конечный результат.

Итак, мы начинаем интерактивную сессию **rebase** от текущего **HEAD** (совершить **30374054** ), чтобы совершить **3233cb21** , с намерением объединить **3** последних коммита в один:

```shell
$ git rebase -i HEAD~3 
```

Это откроет редактор с чем-то вроде следующего:

```shell
pick 3233cb21 Prototype for Notebook page 
 pick 8490f5fc Minor formatting and Punctuation changes 
 pick 30374054 Add Jupyter Notebook to Data Science Tools 
 # Rebase 
 # 
 # Commands: 
 #  p, pick = use commit 
 #  r, reword = use commit, but edit the commit message 
 #  e, edit = use commit, but stop for amending 
 #  s, squash = use commit, but meld into previous commit 
 #  f, fixup = like "squash", but discard this commit's log message 
 #  x, exec = run command (the rest of the line) using shell 
 # 
 # These lines can be re-ordered; they are executed from top to bottom. 
 # 
 # If you remove a line here THAT COMMIT WILL BE LOST. 
 # 
 # However, if you remove everything, the rebase will be aborted. 
 # 
 # Note that empty commits are commented out 
```

Как всегда, Git дает нам очень приятное справочное сообщение, где вы можете увидеть этот вариант `squash` мы ищем.

В настоящее время инструкции по интерактивной перестановке говорят о том, чтобы `pick` каждую указанную фиксацию **и** сохранить соответствующее сообщение фиксации. То есть - ничего не меняйте. Но мы хотим иметь только одну фиксацию в конце. Просто измените текст в вас редакторе замены `pick` с `squash` (или просто `s` ) рядом года каждые фиксацию мы хотим , чтобы избавиться от и сохранения / выхода из редактора. Это может выглядеть так:

```shell
s 3233cb21 Prototype for Notebook page 
 s 8490f5fc Minor formatting and Punctuation changes 
 pick 30374054 Add Jupyter Notebook to Data Science Tools 
```

Когда вы закроете свой редактор, сохранив эти изменения, он будет немедленно открыт, предлагая выбрать и переписать сообщения о фиксации. Что-то вроде

```shell
# This is a combination of 3 commits. 
 # The first commit's message is: 
 Prototype for Notebook page 
 
 # This is the 2nd commit message: 
 
 Minor formatting and Punctuation changes 
 
 # This is the 3rd commit message: 
 
 Add Jupyter Notebook to Data Science Tools 
 
 # Please enter the commit message for your changes. Lines starting 
 # with '#' will be ignored, and an empty message aborts the commit. 
```

На этом этапе вы можете удалить все сообщения, которые не хотите включать в окончательную версию фиксации, переписать их или просто написать сообщение о фиксации с нуля. Просто помните, что новая версия будет включать все строки, которые не начинаются с символа `#` . Еще раз сохраните и выйдите из редактора.

Теперь ваш терминал должен показать сообщение об `Successfully rebased and updated <branch name>` том числе « `Successfully rebased and updated <branch name>` а журнал git должен показывать хорошую и уплотненную историю только с одним фиксатором. Все посреднические обязательства ушли, и мы готовы объединиться!

### Предупреждение о несоответствии истории локальных и удаленных событий

Эта операция немного опасна, если вы уже опубликовали свой филиал в удаленном репозитории - вы все-таки модифицируете историю фиксации. Так что лучше всего делать операцию сквоша в локальной ветке, прежде чем **нажимать** . Иногда, это будет уже нажато - как бы вы создали запрос на pull в конце концов? В этом случае вам придется **принудительно** изменять изменения в удаленной ветке после выполнения раздачи, так как ваша локальная история и история ветвей в удаленном репозитории различаются:

`shell $ git push origin +my-branch-name`

Сделайте все возможное, чтобы убедиться, что вы единственный, кто использует эту удаленную ветвь на этом этапе, или вы сделаете свою жизнь более трудной, если не будет иметь несоответствия истории. Но так как **раздавливание** обычно выполняется как заключительная операция на ветке, прежде чем избавиться от нее, это обычно не так уж и важно.