---
title: Git Stash
localeTitle: Git Stash
---
## Git Stash

Git имеет область, называемую косой чертой, где вы можете временно сохранить моментальный снимок ваших изменений, не передавая их в репозиторий. Он отделен от рабочего каталога, промежуточной области или хранилища.

Эта функциональность полезна, когда вы вносили изменения в ветку, которую вы не готовы к фиксации, но вам нужно переключиться на другую ветку.

### Изменения тарелки

Чтобы сохранить изменения в кошельке, выполните команду:

```shell
git stash save "optional message for yourself" 
```

Это экономит ваши изменения и возвращает рабочий каталог на то, что было похоже на последнюю фиксацию. Спрятанные изменения доступны из любой ветки в этом репозитории.

Обратите внимание, что изменения, которые вы хотите сохранить, должны находиться в отслеживаемых файлах. Если вы создали новый файл и попытаетесь скрыть ваши изменения, вы можете получить ошибку. `No local changes to save` .

### Просмотр измененных изменений

Чтобы узнать, что находится в вашем тайнике, выполните команду:

```shell
git stash list 
```

Это возвращает список сохраненных снимков в формате `stash@{0}: BRANCH-STASHED-CHANGES-ARE-FOR: MESSAGE` . Часть `stash@{0}` - это имя кошелька, а число в фигурных скобках ( `{ }` ) является индексом этого stash. Если у вас несколько сменных наборов изменений, каждый из них будет иметь другой индекс.

Если вы забыли, какие изменения были внесены в кошельке, вы можете увидеть сводку их с `git stash show NAME-OF-STASH` . Если вы хотите увидеть типичный макет патча diff-style (с изменениями + и s для линейных изменений), вы можете включить опцию `-p` (для патча). Вот пример:

```shell
git stash show -p stash@{0} 
 
 # Example result: 
 diff --git a/PathToFile/fileA b/PathToFile/fileA 
 index 2417dd9..b2c9092 100644 
 --- a/PathToFile/fileA 
 +++ b/PathToFile/fileA 
 @@ -1,4 +1,4 @@ 
 -What this line looks like on branch 
 +What this line looks like with stashed changes 
```

### Получить спрятанные изменения

Чтобы извлечь изменения из кошелька и применить их к текущей ветке, в которой вы находитесь, у вас есть два варианта:

1.  `git stash apply STASH-NAME` применяет изменения и оставляет копию в тайнике
2.  `git stash pop STASH-NAME` применяет изменения и удаляет файлы из тайника

При внесении изменений могут возникнуть конфликты. Вы можете разрешить конфликты, подобные слиянию ( [подробнее см. Git merge](https://guide.freecodecamp.org/git/git-merge/) ).

### Удалить отмеченные изменения

Если вы хотите удалить спрятанные изменения без их применения, запустите команду:

```shell
git stash drop STASH-NAME 
```

Чтобы очистить весь тайник, выполните команду:

```shell
git stash clear 
```

### Дополнительная информация:

*   Команда `git merge` : [руководство FCC](https://guide.freecodecamp.org/git/git-merge/)
*   Документация Git: [stash](https://git-scm.com/docs/git-stash)