---
title: Git
localeTitle: идти
---
## Гит

Git - это система управления распределенной версией с открытым исходным кодом, созданная в 2005 году Линусом Торвальдсом и другими пользователями сообщества разработчиков Linux. Git может работать со многими типами проектов, но чаще всего используется для исходного кода программного обеспечения.

Контроль версий - это система, которая отслеживает изменения файла или группы файлов с течением времени. Когда у вас есть история этих изменений, вы можете найти конкретные версии позже, сравнить изменения между версиями, восстановить файлы, которые вы, возможно, удалили, или вернуть файлы в предыдущие версии.

Система управления _распределенной_ версией означает, что разные пользователи сохраняют свои собственные хранилища проекта вместо работы из одного центрального хранилища. Пользователи автоматически обладают всеми возможностями отслеживания файлов и полной версией истории проекта, не требуя доступа к центральному серверу или сети.

Когда Git инициализируется в каталоге проекта, он начинает отслеживать изменения файлов и сохраняет их в виде «наборов изменений» или «патчей». Пользователи, работающие вместе над проектом, представляют свои смены, которые затем включаются (или отклоняются) в проекте.

**Оглавление**

*   [Понимание трёх разделов проекта Git](#understand-the-three-sections-of-a-git-project)
*   [Установка Git](#install-git)
*   [Настройка среды Git](#configure-the-git-environment)
*   [Инициализация Git в проекте](#initialize-git-in-a-project)
*   [Помощь в Git](#get-help-in-git)
*   [Источники](#sources)
*   [Дополнительная информация](#more-information)

### Понимать три раздела проекта Git

Проект Git будет иметь следующие три основных раздела:

1.  Каталог Git
2.  Рабочий каталог (или рабочее дерево)
3.  Плацдарм

**Каталог Git** (расположенный в `YOUR-PROJECT-PATH/.git/` ) - это место, где Git хранит все необходимое для точного отслеживания проекта. Это включает метаданные и базу данных объектов, которая включает сжатые версии файлов проекта.

**Рабочий каталог** - это то, где пользователь вносит локальные изменения в проект. Рабочий каталог вытаскивает файлы проекта из базы данных объектов каталога Git и помещает их на локальную машину пользователя.

**Промежуточная область** представляет собой файл (также называемый «индекс», «этап» или «кеш»), в котором хранится информация о том, что произойдет с вашей следующей фиксацией. Конец - это когда вы сообщаете Git, чтобы сохранить эти поэтапные изменения. Git берет снимок файлов, как они есть, и постоянно сохраняет этот снимок в каталоге Git.

С тремя разделами есть три основных состояния, в которых файл может быть в любой момент времени: зафиксирован, изменен или поставлен. Вы _изменяете_ файл каждый раз, когда вы вносите изменения в свой рабочий каталог. Затем он _поставил_ при перемещении его в тамбур. Наконец, он _совершил_ после фиксации.

### Установка Git

*   Ubuntu: `sudo apt-get install git`
*   Windows: [Загрузить](https://git-scm.com/download/win)
*   Mac: [Скачать](https://git-scm.com/download/mac)

### Настройка среды Git

Git имеет `git config` tool, который позволяет вам настроить среду Git. Вы можете изменить внешний вид и функции Git, установив определенные переменные конфигурации. Запустите эти команды из интерфейса командной строки на вашем компьютере (Terminal in Mac, Command Prompt или Powershell в Windows).

Существуют три уровня, в которых хранятся эти переменные конфигурации:

1.  Система: находится в `/etc/gitconfig` , применяет настройки по умолчанию для каждого пользователя компьютера. Чтобы внести изменения в этот файл, используйте параметр `--system` с командой `git config` .
2.  Пользователь: находится в `~/.gitconfig` или `~/.config/git/config` , применяет настройки к одному пользователю. Чтобы внести изменения в этот файл, используйте опцию `--global` с помощью команды `git config` .
3.  Проект: расположенный в `YOUR-PROJECT-PATH/.git/config` , применяет настройки только к проекту. Чтобы внести изменения в этот файл, используйте команду `git config` .

Если есть конфликтующие друг с другом параметры, конфигурации на уровне проекта будут переопределять пользовательские уровни, а конфигурации пользовательского уровня будут переопределять системные уровни.

Примечание для пользователей Windows: Git ищет файл конфигурации пользовательского уровня ( `.gitconfig` ) в каталоге `$HOME` ( `C:\Users\$USER` ). Git также ищет `/etc/gitconfig` , хотя он относится к корню MSys, который находится там, где вы решили установить Git в вашей системе Windows при запуске установщика. Если вы используете версию 2.x или более поздней версии Git для Windows, также есть файл конфигурации системного уровня в папке `C:\Documents and Settings\All Users\Application Data\Git\config` в Windows XP и в `C:\ProgramData\Git\config` в Windows Vista и новее. Этот конфигурационный файл может быть изменен только с помощью `git config -f FILE` в качестве администратора.

#### Добавьте свое имя и адрес электронной почты

Git включает имя пользователя и адрес электронной почты как часть информации в фиксации. Вы хотите настроить это в своем конфигурационном файле на уровне пользователя с помощью следующих команд:

```shell
git config --global user.name "My Name" 
 git config --global user.email "myemail@example.com" 
```

#### Изменение текстового редактора

Git автоматически использует текстовый редактор по умолчанию, но вы можете это изменить. Ниже приведен пример использования редактора Atom (опция `--wait` сообщает оболочке ждать текстового редактора, чтобы вы могли выполнять свою работу в нем до того, как программа переместится):

```shell
git config --global core.editor "atom --wait" 
```

#### Добавить цвет в выход Git

Вы можете настроить оболочку для добавления цвета к выходу Git с помощью этой команды:

```shell
git config --global color.ui true 
```

Чтобы просмотреть все ваши настройки конфигурации, используйте команду `git config --list` .

### Инициализировать Git в проекте

Когда Git установлен и настроен на вашем компьютере, вам необходимо инициализировать его в своем проекте, чтобы начать использовать полномочия контроля версий. В командной строке используйте команду `cd` чтобы перейти в верхнюю (или корневую) папку для вашего проекта. Затем запустите команду `git init` . Это устанавливает папку каталога Git со всеми файлами и объектами, которые Git должен отслеживать ваш проект.

Важно, что каталог Git установлен в корневую папку проекта. Git может отслеживать файлы в подпапках, но не будет отслеживать файлы, расположенные в родительской папке, относительно каталога Git.

### Получить помощь в Git

Если вы забыли, как работает какая-либо команда в Git, вы можете получить доступ к помощи Git из командной строки несколькими способами:

```shell
git help COMMAND 
 git COMMAND --help 
 man git-COMMAND 
```

Это отображает страницу руководства для команды в окне оболочки. Чтобы перемещаться, прокручивайте клавиши со стрелками вверх и вниз или используйте следующие сочетания клавиш:

*   `f` или `spacebar` на страницу вперед
*   `b` на страницу назад
*   `q` выйти

### Источники

В этой статье используется информация из книги [Pro Git](https://github.com/progit/progit2) , написанная Скоттом Чаконом и Бен Страубом и опубликованная Apress. Книга полностью представлена ​​в [документации Git](https://git-scm.com/book/en/v2) .

### Дополнительная информация:

*   Для загрузки, документации и учебного пособия на основе браузера: [официальный сайт Git](https://git-scm.com/)
*   Самые полезные команды, когда вы в плохой ситуации с GIT: [О, дерьмо, git!](http://ohshitgit.com/)
