---
title: Tagging in Git
localeTitle: Пометка в Git
---
Маркировка позволяет разработчикам отмечать важные контрольно-пропускные пункты в процессе разработки своих проектов. Например, версии программного обеспечения могут быть помечены. (Пример: v1.3.2). По сути, это позволяет вам присвоить специальное имя (тег).

Чтобы просмотреть все созданные теги в алфавитном порядке:

```bash
git tag 
```

Чтобы узнать больше о теге:

```bash
git show v1.4 
```

Существует два типа тегов:

1.  аннотированный

```bash
git tag -a v1.2 -m "my version 1.4" 
```

2.  облегченный

```bash
git tag v1.2 
```

Они отличаются тем, как они хранятся.  
Они создают теги для текущей фиксации.

Incase, вы хотите пометить предыдущую фиксацию, укажите идентификатор фиксации, который вы хотите пометить:

```bash
git tag -a v1.2 9fceb02 
```

Имена тегов могут использоваться вместо идентификаторов фиксации при проверке и нажатии на фиксацию удаленного репо.

#### Дополнительная информация:

*   Документация Git: [Документация](https://git-scm.com/docs/git-tag)
*   Глава: [Книга](https://git-scm.com/book/en/v2/Git-Basics-Tagging)

Вы можете перечислить все доступные теги в проекте с помощью команды `git tag` (в том случае, если они появятся в алфавитном порядке):
```
$ git tag 
 v1.0 
 v2.0 
 v3.0 
```

Этот способ создания тегов отлично подходит для небольших проектов, но в больших проектах могут быть сотни тегов, поэтому вам может понадобиться отфильтровать их при поиске важного момента в истории. Вы можете найти теги, содержащие определенные символы, добавляющие `-l` в команду `git tag` :
```
$ git tag -l "v2.0*" 
 v2.0.1 
 v2.0.2 
 v2.0.3 
 v2.0.4 
```

## Создать тег

Вы можете создать теги двух типов: аннотированные и легкие. Сначала они являются конкурирующими объектами в базе данных GIT: они проверяются, требуют сообщения (например, коммиты) и хранят другие важные данные, такие как имя, адрес электронной почты и дату. С другой стороны, легкие теги не требуют мессажа или хранения других данных, работающих как указатель на конкретную точку в проекте.

### Создать аннотированный тег

Чтобы создать анотированный тег, добавьте `-a tagname -m "tag message"` в команду `git tag` :
```
$ git tag -a v4.0 -m "release version 4.0" 
 $ git tag 
 v1.0 
 v2.0 
 v3.0 
 v4.0 
```

Как вы можете видеть, `-a` указывает, что вы создаете аннотированный тег, после этого появляется имя тега и, наконец, `-m` за которым следует сообщение тега для хранения в базе данных Git.

### Создайте легкий тег

Легкие теги содержат только контрольную сумму фиксации (никакая другая информация не сохраняется). Чтобы создать его, просто запустите команду `git tag` без каких-либо других параметров (символы -lw в конце имени используются для обозначения облегченных тегов, но вы можете пометить их как хотите):
```
$ git tag v4.1-lw 
 $ git tag 
 v1.0 
 v2.0 
 v3.0 
 v4.0 
 v4.1-lw 
```

На этот раз вы не указали сообщение или другие релевантные данные, поэтому тег содержит только контрольную сумму с привязкой.

## Посмотреть теги

Вы можете запустить команду `git show` для просмотра данных, хранящихся в теге. В случае аннотированных тегов вы увидите данные тега и данные фиксации:
```
$ git show v4.0 
 tag v4.0 
 Tagger: John Cash <john@cash.com> 
 Date:   Mon Sat 28 15:00:25 2017 -0700 
 
 release version 4.0 
 
 commit da43a5fss745av88d47839247990022a98419093 
 Author: John Cash <john@cash.com> 
 Date:   Fri Feb 20 20:30:05 2015 -0700 
 
  finished details 
```

Если тег, который вы смотрите, является легким тегом, вы увидите только зарегистрированные данные фиксации:
```
$ git show v1.4-lw 
 commit da43a5f7389adcb9201ab0a289c389ed022a910b 
 Author: John Cash <john@cash.com> 
 Date:   Fri Feb 20 20:30:05 2015 -0700 
 
  finished details 
```

## Пометка старых коммитов

Вы также можете пометить последние коммиты, используя фиксацию git-тега. Для этого вам нужно указать контрольную сумму (или, по крайней мере, ее часть) в строке команды.

Сначала запустите git log, чтобы узнать контрольную сумму требуемого коммита:
```
$ git log --pretty=oneline 
 ac2998acf289102dba00823821bee04276aad9ca added products section 
 d09034bdea0097726fd8383c0393faa0072829a7 refactorization 
 a029ac120245ab012bed1ca771349eb9cca01c0b modified styles 
 da43a5f7389adcb9201ab0a289c389ed022a910b finished details 
 0adb03ca013901c1e02174924486a08cea9293a2 small fix in search textarea styles 
```

Когда у вас есть контрольная сумма, добавьте ее в конец строки создания тега:
```
$ git tag -a v3.5 a029ac 
```

Вы увидите, что тег был правильно добавлен с помощью `git tag` :
```
$ git tag 
 v1.0 
 v2.0 
 v3.0 
 v3.5 
 v4.0 
 v4.1-lw 
```

## Push-теги

Git не нажимает теги по умолчанию, когда вы запускаете команду git push. Итак, чтобы успешно нажать тег на сервер, вам нужно будет выполнить команду `git push origin` :
```
$ git push origin v4.0 
 Counting objects: 14, done. 
 Delta compression using up to 8 threads. 
 Compressing objects: 100% (16/16), done. 
 Writing objects: 100% (18/18), 3.15 KiB | 0 bytes/s, done. 
 Total 18 (delta 4), reused 0 (delta 0) 
 To git@github.com:jcash/gitmanual.git 
 * [new tag]         v4.0 -> v4.0 
 ``` 
 
 You can also use the ```--tags``` option to add multiple tags at once with the ```git push origin``` command: 
```

$ git push origin --tags Подсчет объектов: 1, сделано. Написание объектов: 100% (1/1), 160 байт | 0 байт / с, сделано. Всего 1 (дельта 0), повторно используется 0 (дельта 0) Перейти к git@github.com: jcash / gitmanual.git

*   \[новый тег\] v4.0 -> v4.0
*   \[новый тег\] v4.1-lw -> v4.1-lw
```
## Checking out Tags 
 
 You can use ```git checkout``` to checkout to a tag like you would normally do. But you need to keep in mind that this would result a *detached HEAD* state. 
```

$ git checkout v0.0.3 Примечание: проверка «v0.0.3».

Вы находитесь в состоянии «отсоединенный HEAD». Вы можете осмотреться, сделать экспериментальную изменяет и фиксирует их, и вы можете отказаться от любых коммитов, которые вы совершаете в этом не влияя на какие-либо ветви, выполняя другую проверку.
```
## Deleting a Tag 
 
 You may find a situation were you want to delete a certain tag. There's a very useful command for this situations: 
```

$ git tag --delete v0.0.2 $ git tag v0.0.1 v0.0.3 v0.0.4 \`\` \`

### Больше информации

*   [Git Pro - Основы тегов](https://git-scm.com/book/en/v2/Git-Basics-Tagging)
*   [Git Pro - Документация](https://git-scm.com/docs/git-tag)
*   [Git HowTo](https://githowto.com/tagging_versions)
*   [Git tip: Теги](http://alblue.bandlem.com/2011/04/git-tip-of-week-tags.html)
*   [Создание тега](https://www.drupal.org/node/1066342)

### источники

Документация Git: [теги](https://git-scm.com/book/en/v2/Git-Basics-Tagging)