---
title: A simple web server in Go
localeTitle: Простой веб-сервер в Go
---
Язык программирования Go хорошо известен тем, что имеет встроенный веб-сервер. В этой статье вы узнаете, как вы можете легко сделать свой собственный веб-сервер с Go. Вам не понадобятся другие пакеты рядом с теми, которые уже встроены!

Сначала перейдите в свой текстовый редактор. Затем создайте файл с именем `webserver.go` и введите следующий код:

```go
package main 
 
 import ( 
  "net/http" 
  "io" 
 ) 
 
 func main() { 
  http.HandleFunc("/", servePage) 
    http.ListenAndServe(":8080", nil) 
 } 
 
 func servePage(writer http.ResponseWriter, reqest *http.Request) { 
  io.WriteString(writer, "Hello world!") 
 } 
```

Давайте разложим блок кода выше. Мы импортируем пакет `net/http` : этот пакет содержит сам веб-сервер. Затем мы также импортируем пакет `io` , мы воспользуемся этим позже, чтобы фактически что-то предложить клиенту.

В `main` функции мы делаем две вещи. Прежде всего, мы `servePage` серверу разрешить функции, называемой `servePage` обрабатывать весь входящий трафик в `/` -, в этом случае это означает, что он обрабатывает запросы по _любому_ `URL` . Во-вторых, мы фактически активируем сервер. Мы делаем это с помощью функции `ListenAndServe` . Для этой функции требуются два параметра: `port` (как `string` ), в этом случае это `8080` , а `handler` (как `Handler` ) - однако последний еще не важен. Мы просто сделаем это `nil` и все будет работать нормально.

В `servePage` мы делаем только одну простую вещь, пока. Используя пакет `io` и функцию `WriteString` которую он содержит, мы можем ответить на запрос клиентов текстом `Hello world!` (или любой другой строки, конечно). Вы также могли заметить , что `servePage` функция имеет два аргумента: `writer` и `request` . С автором вы можете ответить на `HTTP` запрос, и с `request` вы можете получить больше информации о самом запросе.

Поздравляем! Вы только что создали свой первый веб-сервер! Если вы хотите протестировать его: просто запустите `go run webserver.go` , запустите браузер и перейдите по `http://localhost:8080` !