---
title: if else Statements
localeTitle: if else Заявления
---
## Введение

Оператор `if` выполняет оператор, если указанное условие **истинно** . Если условие **ложно** , другой оператор может быть выполнен с использованием инструкции `else` .

**Примечание.** Оператор `else` является необязательным.

```Go
  x := 7 
  if x%2 == 0 { 
    // This statement is executed if x is even 
  } else { 
    // This statement is executed if x is odd 
  } 
```

Несколько команд `if...else` могут быть вложены для создания предложения `else if` .

```go
  x := 7 
  if x == 2 { 
    // this statement is executed if x is 2 
  } else if x == 4 { 
    // this statement is executed if x is 4 
  } else if x == 7 { 
    // this statement is executed if x is 7 
  } else { 
    // this statement is executed if none of the aboves is true 
  } 
```

В Go вы можете предшествовать условию `if` с выражением. Тогда определение содержащего переменных справедливо для полного блока `if` .

```go
  if x := 3; x == 2 { 
    // this statement is executed if x is 2 
  } else if x == 3 { 
    // this statement is executed if x is 3 
  } else { 
    // this statement is executed if none of the aboves is true 
  } 

```