---
title: Receive data with your web server
localeTitle: Получать данные с вашего веб-сервера
---
После того, как вы настроили свой веб-сервер и убедитесь, что он может обслуживать полезный контент, вы можете сделать его более интерактивным, позволяя ему принимать данные. Начнем с написания кода:

```go
package main 
 
 import ( 
  "net/http" 
  "html/template" 
 ) 
 
 type PAGE struct { 
  NAME string 
 } 
 
 var page PAGE 
 
 func main() { 
  http.HandleFunc("/", servePage) 
  http.ListenAndServe(":8080", nil) 
 } 
 
 func servePage(writer http.ResponseWriter, reqest *http.Request) { 
  page.NAME = request.FormValue("name") 
  template := template.New("sayHello") 
  template, _ = template.Parse("Hello {{.NAME}}!") 
  template.Execute(writer, page) 
 } 
```

Давайте сломаем этот код. Прежде всего, мы начинаем с импорта `net/http` для веб-сервера и `html/template` для шаблонов. В этой статье предполагается, что вы уже знаете, как шаблон в Go. Если вы еще этого не знаете, сначала прочитайте статью о шаблонах.

Затем мы создаем тип `PAGE` с одним слотом в имени `NAME` (это `string` ). Мы также создаем глобальную переменную, называемую `page` типа `PAGE` : созданная нами структура.

В функции `servePage` есть одна вещь, которая действительно важна для этой статьи: метод `FormValue` который мы запускаем по `request` .

Прежде чем мы продолжим, вам сначала нужно знать, как создается `URL` . В качестве примера возьмем следующий `URL` :
```
https://google.com/search?q=free+code+camp 
```

Если вы укажете `URL` выше в своем браузере, он будет выполнять поиск в Google для `free code camp` . `URL` создается следующим образом:

1.  `https://` - это протокол
2.  `google.com` - это имя домена и порт (в этом случае нет упомянутого порта - поэтому браузер использует порт по умолчанию для протокола)
3.  `/search` - это путь
4.  `q=free+code+camp` - это `query`

Запрос - это та часть, о которой мы говорим в этой статье. Сервер Google видит этот `URL` и из-за атрибута `q` в запросе и значения `q` - в этом случае `free+code+camp` - он знает, где он должен искать.

Мы также можем применить это на нашем сервере. Давайте запустим программу и перейдем к браузеру:
```
http://localhost:8080/?name=world 
```

Ответ будет следующим:
```
Hello world! 
```

Как это работает? Ну, мы дали `FormValue` параметр `name` . Таким образом `FormValue` знает, что нам нужно значение атрибута `name` в запросе. В этом случае это `world` , поэтому метод возвращает `world` . Затем эта строка помещается в переменную `page` а шаблон выполняет все остальное.

Это, конечно, действительно простая реализация этой функции, но вы могли бы сделать с ней многое. Например: вы можете принять адреса электронной почты и позволить программе хранить их в файле.