---
title: Using templates with your web server
localeTitle: Использование шаблонов с вашим веб-сервером
---
Когда у вас есть веб-сервер, вы можете вставить данные в свои ответы. Посмотрим на код:

```go
package main 
 
 import ( 
  "net/http" 
  "html/template" 
 ) 
 
 type PAGE struct { 
  NAME string 
 } 
 
 var page PAGE 
 
 func main() { 
  page.NAME = "Mark" 
  http.HandleFunc("/", servePage) 
  http.ListenAndServe(":8080", nil) 
 } 
 
 func servePage(writer http.ResponseWriter, reqest *http.Request) { 
  template := template.New("sayHello") 
  template, _ = template.Parse("Hello {{.NAME}}!") 
  template.Execute(writer, page) 
 } 
```

Теперь запустите эту программу и перейдите в свой браузер, чтобы:
```
http://localhost:8080/ 
```

Ответ будет следующим:
```
Hello Mark! 
```

Но как это работает и что делает код? Ну, прежде всего, мы импортируем пакет `net/http` , чтобы мы могли запускать веб-сервер. Затем мы импортируем пакет `html/template` . Это позволяет использовать функцию templating; и вот о чем эта статья.

Мы также создаем тип `PAGE` , который имеет одно поле под названием `NAME` как `string` типа. Мы также создаем глобальную переменную, называемую `page` типа `PAGE` , созданной нами структурой. В `main` функции мы даем поле `NAME` `page` значение `Mark` - мое имя, но не стесняйтесь использовать свое имя!

Функция `servePage` сначала немного сложна. Давайте разберемся:

```go
func servePage(writer http.ResponseWriter, reqest *http.Request) { 
 
  // 1. Creating a template 
  template := template.New("sayHello") 
 
  // 2. Filling the template 
  template, _ = template.Parse("Hello {{.NAME}}!") 
 
  // 3. Executing the template 
  template.Execute(writer, page) 
 } 
```

Что мы здесь делаем? Давайте посмотрим шаг за шагом:

1.  Мы создаем _шаблон_ . Вам нужно ввести имя, но на самом деле не важно, какое имя вы выберете. Здесь я выбрал `sayHello` .
2.  Затем мы заполняем шаблон некоторым текстом. Обратите внимание на `{{.NAME}}` .
3.  Наконец, мы _выполняем_ шаблон. Это означает, что шаблон заполняется и отправляется клиенту.

Но как мы переходим от `{{.NAME}}` к `Mark` ? Ну, помните, мы использовали переменную `page` в качестве параметра для метода `Execute` ? Этот метод просматривает данные в шаблоне и видит `{{.NAME}}` . `.NAME` указывает на то, что он должен выглядеть на поле с именем `NAME` внутри переменной , которая была задана в качестве параметра при `Execute` называется. В этом случае он находит это поле и принимает к сведению, что это значение - `Mark` . `{{` И `}}` сообщают `Execute` что он должен заменить `{{.NAME}}` на найденное значение. Итак, конечным результатом станет `Hello Mark!` ,

Вы можете иметь несколько полей и несколько `{{.XXX}}` . Это очень простой способ вставить данные в ответы, и теперь вы знаете, как создавать шаблоны в Go!