---
title: Script Src Attribute
localeTitle: Атрибут Script Src
---
## Атрибут Script Src

Атрибут 'src' в tag - это путь к внешнему файлу или ресурсу, который вы хотите связать с вашим документом HTML.

Например, если у вас есть собственный пользовательский файл JavaScript с именем «script.js» и вы хотите добавить его функциональность на свою HTML-страницу, добавьте его так:

```html

<!DOCTYPE html> 
 <html lang="en"> 
  <head> 
    <title>Script Src Attribute Example</title> 
  </head> 
  <body> 
 
  <script src="./script.js"></script> 
  </body> 
 </html> 
```

Это укажет на файл с именем «script.js», который находится в том же каталоге, что и файл .html. Вы также можете ссылаться на другие каталоги, используя «..» в пути к файлу.

```html

<script src="../public/js/script.js"></script> 
```

Затем он переместится на один уровень каталога, затем в «общедоступный» каталог, затем в каталог «js», а затем в файл «script.js».

Вы также можете использовать атрибут 'src' для связи с внешними файлами .js, размещенными третьей стороной. Это используется, если вы не хотите загружать локальную копию файла. Просто имейте в виду, что если ссылка изменится или сетевой доступ не работает, тогда внешний файл, с которым вы связываетесь, не будет работать.

Этот пример ссылается на файл jQuery.

```html

<script src="https://code.jquery.com/jquery-3.2.1.slim.min.js"></script> 
```

#### Дополнительная информация:

[Статья MDN по HTML](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/script#attr-src) tag</a></p></x-turndown>