---
title: Block and Inline Elements
localeTitle: Блочные и строчные элементы
---
## Блочные и строчные элементы

Поясним их, используя приведенные ниже примеры:

#### Образец кода с выводом:

![Блочный вывод](https://user-images.githubusercontent.com/16048167/31070017-6f2cf0a2-a77c-11e7-9de6-110b9d0b488d.PNG)

#### Блочный элемент:

Блочные элементы занимают всю ширину своего родителя (контейнера), например `<div>` и `<p>` в примере.

Обратите внимание, что оба `<div>` и `<p>` начинаются с новой строки каждый раз, образуя **блокоподобную** структуру. Блочные элементы начинаются на новых строках.

Общими **блочными элементами** являются `<div>` , `<p>` , `<article>` , `<section>` , `<figure>` , `<footer>` и т. Д.

#### Строчный элемент:

Inline, поскольку название говорит, «включено как часть основного текста, а не как отдельный раздел». Строчные элементы занимают ширину, определяемую размером содержимого, по мере необходимости. В отличие от блочных элементов, они не начинаются на новых строках.

Некоторые из **строчных элементов** : `<a>` , `<span>` , `<img>` , `<code>` , `<cite>` , `<button>` , `<input>` и т. д.

#### Образец кода с выводом:

![Строчный вывод](https://user-images.githubusercontent.com/16048167/31069389-e1e3fc10-a779-11e7-86d2-6685e0061f52.png)

**_Примечание_** . Блочные элементы могут содержать другие блочные или строчные элементы. Строчные элементы **не могут** содержать блочные элементы.

#### Изменения в HTML5

Хотя понимание блочных и строчных элементов по-прежнему актуально, вы должны знать, что эти термины были определены в предыдущих версиях спецификации HTML. В HTML5 более сложный набор «категорий контента» заменяет блочные и строчные элементы. Категория «строчных» элементов примерно соответствует категории фразового контента, а для «блочных» элементов прямого соответствия нет, но «блочные» и «строчные» элементы вместе примерно соответствуют категории потокового контента. Дополнительные сведения о новых категориях контента в HTML5, включая содержимое потока и содержание фраз, см. На [странице «Категории контента» в Mozilla Developer Network.](https://developer.mozilla.org/ru/docs/Web/Guide/HTML/Content_categories)

#### Дополнительная информация:

Пожалуйста, обращайтесь к [Mozilla Docs](https://developer.mozilla.org/en-US/docs/Web/HTML/Block-level_elements#Block-level_vs._inline)
